var tests = [];
for (var file in window.__karma__.files) {
	if (window.__karma__.files.hasOwnProperty(file)) {
		// Removed "Spec" naming from files
		if (/_spec\.js$/.test(file)) {
			tests.push(file);
		}
	}
}

requirejs.config({
	// Karma serves files from '/base'
	baseUrl: '/base/app/modules',

	paths: {
		angularMocks					: '../libs/angular-mocks/js/angular-mocks',

		/*                  Libraries                    */
		'angular'						: '../libs/angular/js/angular',
		'angularSanitize'				: '../libs/angular-sanitize/js/angular-sanitize',
		'angularTouch'					: '../libs/angular-touch/js/angular-touch',
		'angularAnimate'				: '../libs/angular-animate/js/angular-animate',
		'jQuery'						: '../libs/jquery/js/jquery',
		'lodash'						: '../libs/lodash/js/lodash',
		'text'							: '../libs/requirejs-text/text',
		'angularUiMask'					: '../libs/angular-ui-mask/js/mask',
		'angularUiRouter'				: '../libs/angular-ui-router/js/angular-ui-router',
		'angularUiBootstrap'			: '../libs/angular-bootstrap/js/ui-bootstrap-tpls-custom',
		'angularBusy'					: '../libs/angular-busy/js/angular-busy',
		'snap'							: '../libs/snap/js/snap',
		'angularSnap'					: '../libs/angular-snap/js/angular-snap',
		'moment'						: '../libs/moment/js/moment',
		'Modernizr'						: '../libs/modernizr/modernizr-build',

		/*                  Decorations                    */
		'uiCollapseDirective'			: 'decorations/ui-collapse_decorator',

		/*                  Application                    */
		'appConfig'						: 'app-config',
		'app'							: '../../test/spec/appMock',
		'router'						: 'router',
		//templates is generated by grunt ngtemplate task
		'templates'						: 'templates',
		'ResponsiveDirective'			: 'ui-components/responsive/responsive_directive',

		/*                  Container                    */
		'MainController'				: 'container/main/main_controller',
		'SplashController'				: 'container/splash/splash_controller',

		'HeaderController'				: 'container/components/header/header_controller',
		'FooterController'				: 'container/components/footer/footer_controller',
		'TwoPanelController'			: 'container/components/content/two-column_controller',
		'List'							: 'container/components/content/list/list_directive',
		'Menu'							: 'container/components/menu/menu_directive',
		'SecondaryNavigationController' : 'container/components/content/secondary-navigation/secondary-navigation_controller',

		/*                  Applets                    */
		//Home
		'HomeModule'					: 'applets/home/home_module',
		'AppSelectController'			: 'applets/home/pages/app-select/app-select_controller',
		'appSelectService'				: 'applets/home/pages/app-select/app-select_service',
		'carouselService'				: 'applets/home/carousel-tour/carousel_service',
		'LandingController'				: 'applets/home/pages/landing/landing_controller',
		'HealthReportTestFixtures'      : '../../test/assets/health_report_test_fixtures',

		//Common
		'SubheaderController'			: 'applets/shared/pages/subheader/subheader_controller',
		'SubmitController'				: 'applets/shared/pages/submit/submit_controller',
		'ConsentController'				: 'applets/shared/pages/consent/consent_controller',
		'consentService'				: 'applets/shared/pages/consent/consent_service',
		'FailedController'				: 'applets/shared/pages/submit-status/failed/failed_controller',
		'RetryController'				: 'applets/shared/pages/submit-status/retry/retry_controller',
		'SuccessController'				: 'applets/shared/pages/submit-status/success/success_controller',
		'mediaRequestTypes'				: 'applets/shared/services/media-request-types_value',
		'questionnaireService'			: 'applets/shared/services/questionnaire_service',
		'questionnaireResponseService'	: 'applets/shared/services/questionnaire-response_service',

		//MyTelederm
		'TeledermRequestInfoController'	: 'applets/mytelederm/pages/media-request-info/telederm-request-info_controller',
		'TeledermEvalController'		: 'applets/mytelederm/pages/telederm-eval-controller/telederm-eval_controller',
		'SkinStatusController'			: 'applets/mytelederm/pages/skin-status/skin-status_controller',
		'MedicationsController'			: 'applets/mytelederm/pages/medications/medications_controller',
		'MedicationsEntryController'	: 'applets/mytelederm/pages/medications/medications-entry_controller',
		'AdditionalCommentsController'	: 'applets/mytelederm/pages/additional-comments/additional-comments_controller',
		'ResponseSummaryController'		: 'applets/mytelederm/pages/response-summary/response-summary_controller',
		'PhotoInstructionsController'   : 'applets/mytelederm/pages/photo-instructions/photo-instructions_controller',
		'PhotoInputController'			: 'applets/mytelederm/pages/photo-input/photo-input_controller',
		'RequiredPhotoController'		: 'applets/mytelederm/pages/photo-input/required-photo/required-photo_controller',
		'CloseUpPhotoController'		: 'applets/mytelederm/pages/photo-input/close-up-photo/close-up-photo_controller',
		'OptionalPhotoController'		: 'applets/mytelederm/pages/photo-input/optional-photo/optional-photo_controller',
		'TakeAnotherPictureController'	: 'applets/mytelederm/pages/take-another-picture/take-another-picture_controller',
		'ReviewPhotosController'		: 'applets/mytelederm/pages/review-photos/review-photos_controller',
		'TeledermSubmitController'		: 'applets/mytelederm/pages/submit/telederm-submit_controller',
		'teledermSubmitStatusValue'		: 'applets/mytelederm/pages/submit-status/telederm-submit-status_value',
		'TeledermRetryController'		: 'applets/mytelederm/pages/submit-status/telederm-retry_controller',

		'medicationTypesValue'			: 'applets/mytelederm/services/medication-types_value',

		'mediaRequestNavigationService': 'applets/mytelederm/services/media-request-navigation_service',
		'mediaRequestProgressService'	: 'applets/mytelederm/services/media-request-progress_service',
		'imageMediaRequestService'		: 'applets/mytelederm/services/image-media-request_service',
		'imageRotationService'			: 'applets/mytelederm/services/image-rotation_service',
		'imageUploadService'			: 'applets/mytelederm/services/image-upload_service',
		'medicationsEntryService'		: 'applets/mytelederm/pages/medications/medications-entry_service',
		'teledermSubmitEvaluationService'	: 'applets/mytelederm/services/telederm-submit-evaluation_service',
		'imageResponseService'			: 'applets/mytelederm/services/image-response_service',
        
        //MyVideo
        'VideoRequestInfoController' 	: 'applets/myvideo/pages/media-request-info/video-request-info_controller',
        'VideoRequestsController' 		: 'applets/myvideo/pages/media-requests/video-requests_controller',
		'VideoInstructionsController'	: 'applets/myvideo/pages/video-instructions/video-instructions_controller',
		'VideoUploadController'			: 'applets/myvideo/pages/video-upload/video-upload_controller',
		'VideoSubmitController'			: 'applets/myvideo/pages/submit/video-submit_controller',
		'VideoRetryController'			: 'applets/myvideo/pages/submit-status/video-retry_controller',
		'videoRequestsService'			: 'applets/myvideo/pages/media-requests/video-requests_service',
		'videoService'					: 'applets/myvideo/services/video_service',
		'videoUploadService'			: 'applets/myvideo/services/video-upload_service',
		'videoSubmitEvaluationService'	: 'applets/myvideo/services/video-submit-evaluation_service',
		'videoSubmitStatusValue'		: 'applets/myvideo/pages/submit-status/video-submit-status_value',

		//Shared
		'progressService'				: 'applets/shared/services/progress_service',

		/*                  Core Components                    */
		'httpMock'						: 'core/services/http-mock_service',

		'httpInterceptor'				: 'core/connection/httpInterceptor',
		'connection_error_service'		: 'core/connection/connection_error_service',
		'connection_timeout_service'	: 'core/connection/connection_timeout_service',
		'delayManager'					: 'core/connection/delay_factory',

		'EulaController'				: 'core/eula/eula_controller',
		
		'fhirPatientService'			: 'core/resources/fhir-patient_service',
		'fhirResources'					: 'core/resources/fhir-resources_service',
		'localResourceDirectoryService'	: 'core/resources/local-resource-directory_service',
		'mhpuser_service'				: 'core/resources/mhpuser_service',
		'patient'						: 'core/resources/patient_service',
		'userSessionService'		    : 'core/resources/user-session_service',

		'CollectionCRUDService'		    : 'core/services/collection-crud_service',
		'BaseCRUDService'               : 'core/services/base-crud_service',
		'global'						: 'core/services/global',
		'formatter'						: 'core/services/formatter',
		'authentication_service'		: 'core/services/auth_service',
		'unsavedChanges'				: 'core/services/unsaved_changes',
		'focusManager'					: 'core/services/focus_directive',
		'localStorageService'			: 'core/services/local-storage_service',
		'sessionStorageService'			: 'core/services/session-storage_service',
		'fileValidationService'			: 'core/services/file-validation_service',


		'MediaRequestsController'		: 'applets/shared/pages/media-requests/media-requests_controller',
		'MediaRequestInfoController'	: 'applets/shared/pages/media-request-info/media-request-info_controller',
		'TeledermRequestsController'	: 'applets/mytelederm/pages/media-requests/telederm-requests_controller',
		'TeledermRequestsService'		: 'applets/mytelederm/pages/media-requests/telederm-requests_service',
		'NavigationInstructionsService'	: 'applets/shared/services/navigation-instructions_service',
		'submitEvaluationService'		: 'applets/shared/services/submit-evaluation_service',

		/*                  ui-components                         */
		'EntryForm'						: 'ui-components/form/entry-form/entry-form_directive',

		'FormControlWrapper'			: 'ui-components/form/controls/core/form-control-wrapper/form-control-wrapper_directive',
		'iOSKeyboard'					: 'ui-components/form/controls/core/iOS-keyboard/iOS-keyboard_directive',

		'InputRange'					: 'ui-components/form/controls/simple/input-range/input-range_directive',
		'InputSelect'					: 'ui-components/form/controls/simple/input-select/input-select_directive',
        'InputTypeAhead'				: 'ui-components/form/controls/simple/input-type-ahead/input-type-ahead_directive',
		'InputText'						: 'ui-components/form/controls/simple/input-text/input-text_directive',
		'InputFile'						: 'ui-components/form/controls/simple/input-file/input-file_directive',
		'InputNumber'					: 'ui-components/form/controls/simple/input-number/input-number_directive',
		'InputPhoto'					: 'ui-components/form/controls/simple/input-photo/input-photo_directive',
		'InputVideo'					: 'ui-components/form/controls/simple/input-video/input-video_directive',
		'InputGroupCheckbox'			: 'ui-components/form/controls/simple/input-group-checkbox/input-group-checkbox_directive',
		'InputGroupRadio'				: 'ui-components/form/controls/simple/input-group-radio/input-group-radio_directive',
		'accessibleDatePickerServices'	: 'ui-components/form/controls/simple/accessibledatepicker/accessibledatepicker_directive',
		'accessibleTimePickerServices'	: 'ui-components/form/controls/simple/accessibletimepicker/accessibletimepicker_directive',

		'CalendarDatePicker'			: 'ui-components/form/controls/simple/calendar-date-picker/calendar-date-picker_directive',
    	'InputCalendarDatePicker'		: 'ui-components/form/controls/composite/input-calendar-date-picker/input-calendar-date-picker_directive',

		'TimeControls'					: 'ui-components/form/controls/composite/input-time-picker/time-controls_directive',
		'InputDateTime'					: 'ui-components/form/controls/composite/input-date-time/input-date-time_directive',
		'MultiTime'						: 'ui-components/form/controls/composite/input-multi-time-picker/multi-time_directive',
		'MultiPhone'					: 'ui-components/form/controls/composite/input-multi-phone/multi-phone_directive',
		'NotificationDeliveryOptions'	: 'ui-components/form/controls/composite/notification-delivery-options/notification-delivery-options_directive',

		'UserInputPattern'				: 'ui-components/form/validation/user-input-pattern/user-input-pattern_directive',
		'ValidationSummary'				: 'ui-components/form/validation/validation-summary/validation-summary',
		'ErrorHandling'					: 'ui-components/form/validation/validation-summary/error-handling_directive',
		'RequiredField'					: 'ui-components/form/validation/required-field-indicator/required-field-indicator_directive',

		'modalService'					: 'ui-components/modals/helper/modal_service',
		'HelpController'				: 'ui-components/modals/help/help_controller',
        'AboutController'				: 'ui-components/modals/about/about_controller',
        'ResourcesController'			: 'ui-components/modals/resources/resources_controller',
		'ConfirmSaveController'			: 'ui-components/modals/confirm-save/confirm-save_controller',
		'ConfirmDialController'			: 'ui-components/modals/confirm-dial/confirm-dial_controller',
		'ConfirmNavigationController'	: 'ui-components/modals/confirm-navigation/confirm-navigation_controller',
		'NavigationInstructionsController': 'ui-components/modals/navigation-instructions/navigation-instructions_controller',
		'PhotoTipsController'			: 'ui-components/modals/photo-tips/photo-tips_controller',
		'TeledermTipsController'		: 'ui-components/modals/telederm-tips/telederm-tips_controller',
		'ConsentDeclinedController'		: 'ui-components/modals/consent-declined/consent-declined_controller',
		'ViewVideoController'			: 'ui-components/modals/view-video/view-video_controller',
		'ConfirmMediaUpdateController'	: 'ui-components/modals/confirm-media-update/confirm-media-update_controller',

		'FilterButton'					: 'ui-components/filter-button/filter-button_directive',
		'FilterWrapper'					: 'ui-components/filter/filter-wrapper_directive',
		'StatusFilter'					: 'ui-components/filter/status-filter/status-filter_directive',

		'AriaHidden'					: 'ui-components/accessibility/aria-hidden/aria-hidden_directive',
		'SrAlert'						: 'ui-components/accessibility/sr-alert/sr-alert_directive',

		'aDirecitve'					: 'ui-components/html-extensions/a_directive',
		'iDirecitve'					: 'ui-components/html-extensions/i_directive',

		'limitLength'					: 'ui-components/limit-length/limit-length_filter',

		'DataTableDirective'			: 'ui-components/table/table_directive',

		'BackButton'					: 'ui-components/back-button/back-button_directive',

		'AccessibleAccordion'			: 'ui-components/accordion/accessibleaccordion_directive',

        'navBar'                        : 'ui-components/nav-bar/nav-bar_directive',
		'ProgressBar'					: 'ui-components/progress-bar/progress-bar_directive',
		'ScrollIndicator'				: 'ui-components/scroll-indicator/scroll-indicator_directive',
	},

	shim: {
		'jQuery'				: {exports: '$'},
		'lodash'				: {'exports': '_'},
		'angular'				: {deps: ['jQuery'], 'exports': 'angular'},
		'angularRoute'			: ['angular'],
		'angularCookies'		: ['angular'],
		'angularAnimate'		: ['angular'],
		'angularSanitize'		: ['angular'],
		'angularResource'		: ['angular'],
		'angularUiRouter'		: ['angular'],
		'angularUiBootstrap'	: ['angular'],
		'angularBusy'			: ['angular'],
		'Modernizr'				: { exports: 'Modernizr' },
		'app'					: { deps: ['angular'], exports: 'app' },
		'main_controller'		: {
									deps: ['app'],
									exports: 'main_controller'
								},
		'eula_service': 			{
									deps: ['app', 'jQuery'],
									exports: 'service'
								},
		'eula_controller': 		{
									deps: ['app', 'eula_service'],
									exports: 'eula_controller'
								},
		'angularMocks': 		{
									deps: ['angular'],
									'exports': 'angular.mock'
								}
	},
 map: {
    "*": {
        "jquery": "jQuery"
    }
   },
	// ask Require.js to load these files (all our tests)
	deps: tests,

	// start test run, once Require.js is done
	callback: window.__karma__.start
});
