# MyTelederm Web Application

## Purpose
 The My VA Images app is a system that provides VA patients the ability to follow-up remotely with their dermatologist and submit relevant images captured via the veteran's device.

##  Platform
* **Base Image:** Centos7 / Nginx

## Services and Accounts
* **Service:** my-va-images
* **Port (in NextGen Stack):** PORT
* **Test User:** mockUser01/pass

### Dependencies
* **[image-service](https://URL/projects/IAS/repos/image-service/browse):** Allows for vet follow-up with their dermatologist.

## Local Builds
### NextGen Local Development

This application includes `common.gradle` functionality for build and run capabilities. Some helpful tasks include:

|    Task    |  Action  |
| ---------- | -------- |
| `buildDev` |  Builds the application (runs `build.sh`) |
| `runDev`   |  Starts the application containers |
| `runStack` |  Start the nextgen-stack using the overrides specified in `set-dev-override-envars.sh` |

These tasks are called with the `gradlew` script, and can be run singly or grouped. For example, all of the above tasks can be called in one command:

```sh
./gradlew runStack buildDev runDev
```

Please see the [gradle-commons](https://URL/projects/VAMF/repos/gradle-commons) repo for further documentation.

#### Docker app build

From the my-va-images folder:

```sh
./gradlew buildDev
```

#### Docker image build

From the my-va-images folder:

```sh
./gradlew buildDevImage
```

#### Deploy
* Clone new-configuration branch of [NextGen-Stack repository](https://URL/projects/VAMF/repos/nextgen-stack/browse)
	* Currently, this must be in a "peer" directory this application (accessible with `../nextgen-stack`)
* Follow README of above repository for basic environment prerequisites

* Bring up nextgen-stack with `./gradlew runStack`.
* Bring up the application with `./gradlew runDev`. This will also call tasks to:
	* Pull and run any locally-defined microservice/backend containers (as defined in `/nextgen/docker-compose.dev.yml`)
	* Add all necessary key/value pairs and other data into consul (as defined in `nextgenConfig.yml`)
	* Register services with APIGateway as necessary (as defined in `nextgenConfig.yml`)

#### Registraton
Consul properties and APIGateway registration are handled as pre-/post- requisites of the `runDev` task as described above. To run them independently, use:

```sh
./gradlew setConsulVars
./gradlew registerWithAPIGateway
```

#### Verification
If the application is setup correctly in the local NextGen Stack environment, you should be able to access the application at:
http://localhost:8089/myvaimages/

#### Redeploying
After making a change to the code, the following steps can be followed to redeploy the my-va-images image.

From the my-va-images folder:

```sh
./gradlew stopDev buildDev runDev
```

## References
* **Stash repo link:** https://URL/projects/MTD/repos/my-va-images/browse?at=refs%2Fheads%2Frelease%2F1.0
* **Stash clone link:** https://URL/scm/mtd/my-va-images.git
* **Wiki Documentation:** [MyVAImages 1.0](https://URL/display/MTD/My+VA+Images+Home)