#!/bin/bash

echo -e "\nSourcing ./set-dev-override-envars.sh"
source ./set-dev-override-envars.sh

# Start the nextgen stack if requested
START_NEXTGEN_STACK=$1
if [[ $START_NEXTGEN_STACK = true ]]; then
    echo -e "\nStarting nextgen-stack"
    export TAIL_LOGS=false
    pushd ../nextgen-stack
    ./run-all.sh 
    popd
fi

# Source the nextgen-stack environment variables including overrides for this application
echo -e "\nSourcing ../nextgen-stack/set-dev-envars.sh"
source ../nextgen-stack/set-dev-envars.sh

echo -e "\nCompile My VA Images Front-End code\n"
./nextgen/build.sh || { echo "FATAL: Failed to build My VA Images Front-End"; exit 1; }

echo -e "\nStop and remove running My VA Images containers\n"
./nextgen/stop-dev.sh

echo -e "\nSetting needed environment variables in Consul"
./nextgen/set_myvaimages_consul_vars-dev.sh || { echo "FATAL: Failed to set needed environment variables in Consul"; exit 1; }

echo -e "\nStart My VA Images containers\n"
docker-compose -f nextgen/docker-compose-dev.yml up -d --build || { echo "FATAL: Failed to start My VA Images containers"; exit 1; }

echo -e "\nRegister My VA Images application services with Consul"
./nextgen/register_myvaimages_services-dev.sh || { echo "FATAL: Failed to register My VA Images application services with Consul"; exit 1; }