#!/bin/bash -x

printf "\n**** Starting Mandatory: Fortify ********************\n"

source ./nextgen/app.env;

DEBUG=false
SOURCEANALYZER="sourceanalyzer"
BUILD_NUMBER="${BUILD_NUMBER:-SNAPSHOT}"
ARTIFACT_ID="${APP_NAME}-${APP_VERSION}+${BUILD_NUMBER}"
FILE_PREFIX="${APP_NAME}-${APP_VERSION%.*}"
FPR="fortify/${FILE_PREFIX}.fpr"
PDF="fortify/${FILE_PREFIX}.pdf"
TEMPLATE="Security_Report.xml"


MEMORY="-Xmx3200M -Xms2400M -Xss48M"
REPORT_OPTIONS="-showRemoved -showSuppressed -showHidden -verbose"

echo "Running Fortify scan...";

echo "DEBUG=${DEBUG}"
echo "PWD=$PWD"
echo "JOB_NAME=$JOB_NAME"
echo "BUILD_NUMBER=$BUILD_NUMBER"
echo "WORKSPACE=$WORKSPACE"
echo "PROJECT_ROOT=$PROJECT_ROOT"
echo "JAVA_HOME=$JAVA_HOME"
echo "MEMORY=$MEMORY"
echo "REPORT_OPTIONS=$REPORT_OPTIONS"
echo "FPR=$FPR"
echo "APP_NAME=${APP_NAME}"
echo "APP_VERSION=${APP_VERSION}"
echo "Listing files in current directory: $PWD";
ls -lh;

if [ $DEBUG = true ];
    then export LAUNCHERSWITCHES="-debug -show-build-warnings $LAUNCHERSWITCHES";
fi

cd /root/workspace/

scratch=$(mktemp -d -t tmp.XXXXXXXXXX)

# exit script if any command fails
set -eo pipefail

function cleanup {
    echo --------------------------------------
    echo Cleaning up workspace
    rm -rf "$scratch"
}

trap cleanup EXIT

# Make sure rulepacks are up to date
echo --------------------------------------
echo Updating rulepacks
fortifyupdate

echo --------------------------------------
echo Cleaning previous scan artifacts...
$SOURCEANALYZER $MEMORY -b $BUILD_NUMBER -clean -verbose

echo --------------------------------------
echo Translating project...
$SOURCEANALYZER $MEMORY $LAUNCHERSWITCHES -b $ARTIFACT_ID -source 1.8 @fortify/fortifyConfig.properties -verbose
echo --------------------------------------

echo Starting scan
$SOURCEANALYZER $MEMORY $LAUNCHERSWITCHES -b $ARTIFACT_ID -build-label $ARTIFACT_ID -source 1.8 -scan -f $FPR -verbose
echo --------------------------------------

echo -e "\nGenerating PDF report...";
ReportGenerator -format pdf -f "${ARTIFACT_ID}.pdf" -source "$FPR" -template $TEMPLATE ${REPORT_OPTIONS} || true;

printf "\n**** Ending Mandatory: Fortify ********************\n\n"
