#!/bin/bash

printf -- "\n\n------------------------------------";
printf -- "\n-- My VA Images Build ";
printf -- "\n------------------------------------\n";

# use template as base, do initial replacement for DTR_PREFIX
/usr/bin/perl -pe "s|%%DTR_PREFIX%%|$DTR_PREFIX|" nextgen/Dockerfile-template | /usr/bin/perl -pe "s|%%DTR_ORG%%|$DTR_ORG|" > nextgen/Dockerfile || { echo "FATAL: Could not set DTR PREFIX or ORG"; exit 1; }

npm install || { echo "FATAL: Failed on 'npm install'"; exit 1; }
gem install bundler
bundle install || { echo "FATAL: Failed on 'bundle install'"; exit 1; }

printf "\n\n**** Gradle Build ********************\n"
grunt build:dist || { echo "FATAL: Failed on 'grunt build:dist'"; exit 1; }

# Build Artifact Production
printf "\n\n**** Produce Build Artifacts ********************\n"

tar -zcvf $JOB_NAME.BUILD-$BUILD_NUMBER.tar.gz ./dist nextgen docker-compose.yml || { echo "FATAL: Failed on 'Artifact tar'"; exit 1; }

printf "\n\n\n\n**** COMPLETED build.sh ********************\n\n"
