module.exports = function(grunt) {

	grunt.config('watch', {
		js: {
			files: ['<%= yeoman.app %>/modules/{,*/}*.js'],
					tasks: ['newer:jshint:all'],
					options: {
				livereload: true
			}
		},
		jsTest: {
			files: ['test/spec/{,*/}*.js'],
					tasks: ['newer:jshint:test', 'karma']
		},
		compass: {
			files: ['<%= yeoman.app %>/_assets/css/{,*/}*.{scss,sass}'],
					tasks: ['compass:server', 'autoprefixer']
		},
		gruntfile: {
			files: ['Gruntfile.js']
		},
		livereload: {
			options: {
				livereload: '<%= connect.options.livereload %>'
			},
			files: [
				'<%= yeoman.app %>/{,*/}*.html',
				'.tmp/styles/{,*/}*.css',
				'<%= yeoman.app %>/_assets/images/{,*/}*.{png,jpg,jpeg,gif,webp,svg}'
			]
		}
	});

	grunt.loadNpmTasks('grunt-contrib-watch');

};