module.exports = function(grunt) {

	grunt.config('copy', {
		dev: {
			files: [{
				expand: true,
				dot: true,
				cwd: '<%= yeoman.app %>',
				dest: '<%= yeoman.dist %>',
				src: [
					'**/*.json',
					'**/*.js',
					'**/*.html',
					'modules/**/*.css',
					'favicon.ico',
					'libs/**/css/*.css',
					'_assets/pdfs/*',
					'!index*.html',
					'_assets/fonts/**/*',
					'_assets/css/*.css',
					'!_assets/fonts/**/*.html',
					'_assets/fonts/**/*.css',
					'!**/*_spec.js',
					'libs/angular-busy/images/ajax-loader.gif'
				]
			}, {
				expand: true,
				dot: true,
				cwd: '<%= yeoman.app %>',
				dest: '<%= yeoman.dist %>/_assets/fonts',
				src: [
					'libs/sass-bootstrap/fonts/*extended*.*'
				],
				flatten: true
			}]
		},
		dist: {
			files: [{
				expand: true,
				dot: true,
				cwd: '<%= yeoman.app %>',
				dest: '<%= yeoman.dist %>',
				src: [
					'**/*.json',
					'**/*.html',
					'favicon.ico',
					'_assets/pdfs/*',
					'!index*.html',
					'modules/**/*.css',
					'_assets/fonts/**/*',
					'!_assets/fonts/**/*.html',
					'!_assets/fonts/**/*.css'
				]
			}, {
				expand: true,
				dot: true,
				cwd: '<%= yeoman.app %>',
				dest: '<%= yeoman.dist %>/_assets/fonts',
				src: [
					'libs/sass-bootstrap/fonts/*extended*.*'
				],
				flatten: true
			}]
		},
		healthReportCss: {
			files: [{
				// TODO: waiting on https://github.com/yeoman/grunt-usemin/pull/412 for correct path detection in usemin search paths
				//  once this is complete, remove this copy job and references in dev and dist build
				expand: true,
				dot: true,
				cwd: '<%= yeoman.app %>/../.tmp/_assets/css',
				dest: '<%= yeoman.dist %>/_assets/css',
				src: ['health-report.css'],
				flatten: true
			}]
		}
	});

	grunt.loadNpmTasks('grunt-contrib-copy');

};