module.exports = function(grunt) {

	grunt.config('compass', {
		main: {
			options: {
				sassDir: '<%= yeoman.app %>/_assets/sass/main',
				cssDir: '.tmp/_assets/css',
				imagesDir: '<%= yeoman.app %>/_assets/images',
				javascriptsDir: '<%= yeoman.app %>/libs',
				importPath: ['<%= yeoman.app %>/libs', '<%= yeoman.app %>/modules', '<%= yeoman.app %>/_assets/sass/main'],
				trace: true,
				relativeAssets: false,
				assetCacheBuster: false,
				noLineComments: true,
				debugInfo: false,
				raw: 'Sass::Script::Number.precision = 10\n'
			},
			server: {
				options: {
					debugInfo: false
				}
			}
		},
		healthReport: {
			options: {
				sassDir: '<%= yeoman.app %>/_assets/sass/health-report',
				cssDir: '.tmp/_assets/css',
				importPath: ['<%= yeoman.app %>/libs', '<%= yeoman.app %>/modules', '<%= yeoman.app %>/_assets/sass/health-report'],
				trace: true,
				relativeAssets: false,
				assetCacheBuster: false,
				noLineComments: true,
				debugInfo: false,
				raw: 'Sass::Script::Number.precision = 10\n'
			},
			server: {
				options: {
					debugInfo: false
				}
			}
		}
	});

	grunt.loadNpmTasks('grunt-contrib-compass');

};
