#!/bin/bash
usage()
{
    echo "Usage:$0 <api-gateway-base> <pgd host:port> <veteran ICN> "
    echo "Ex: load-data.sh localhost:PORT localhost:PORT 1006088937V099668 my-user my-password"
    echo ""
    echo "##############################################################################################"
    echo "Script requires API Gateway host:port, PGD FHIR host:port, veteran ICN, AdminIDP username and password to run. <mandatory>"
    echo "##############################################################################################"
}
if [[ $# -eq 0 ]]; then
   usage
   exit 1
fi

BASE_URL=$1
PGD_FHIR_URL=$2
ICN=$3
USER=$4
PASSWORD=$5

printf "BASE_URL = $BASE_URL\n"
printf "PGD_FHIR_URL = $PGD_FHIR_URL\n"
printf "ICN = $ICN\n"

printf "\nGenerating Admin JWT\n"
printf "===========================================\n"
JWT=$(curl -u ${USER}:${PASSWORD} --header "Content-Type: application/json" "$BASE_URL/admin/v1/jwt/system/healthchecks" | jq ".jwt" | tr -d '"')
echo $JWT

printf "\nRetrieving Current Questionnaires\n"
printf "===========================================\n"
results=$(curl -G --header "X-VAMF-JWT: $JWT" --insecure --header "Content-Type:application/json" "http://${PGD_FHIR_URL}/pgd-fhir-services/v1/fhir/Questionnaire" --data-urlencode "publisher=MyVAImages" --data-urlencode "_count=100")
count=$(jq ".total" <<< $results)
printf "\nResults found: $count\n"
printf "===========================================\n"

# only delete if there are results returned
if [[ $count -ne 0 ]]; then
  printf "\nDeleting Current Questionnaires\n"
  printf "===========================================\n"
  resources_urls=$(jq ".entry[].fullUrl" <<< $results)
  printf "results:\n$resources_urls"

  while read -r line; do
    # trim beginning and trailing quotes
    len=${#line}-1
    line="${line:1:len-1}"

    curl -X DELETE ${line} --header "X-VAMF-JWT: $JWT" --insecure --header "Content-Type:application/json"
  done <<< "$resources_urls"
fi

printf "\nSeeding Questionnaires Start\n"
printf "===========================================\n"

while read -r line || [[ -n $line ]];
do
    if [ ${line:0:1} == "[" ]; then
        line="${line:1}"
    fi
    len=${#line}-1
    line="${line:0:len}"

	curl -X POST http://${PGD_FHIR_URL}/pgd-fhir-services/v1/fhir/Questionnaire -H "x-vamf-jwt: $JWT" -H "Content-Type:application/json" -d "${line}"
done <"questionnaireDataImport.json"

printf "\nSeeding Questionnaires End\n"
printf "===========================================\n"