#!/bin/bash
usage()
{
    echo "Usage:$0 <pgd host:port> <admin-jwt>"
    echo "Ex: $0 IP                 eyxxx"
    echo ""
    echo "##############################################################################################"
    echo "Script requires an authenticated admin JWT to run. <mandatory>"
    echo "##############################################################################################"
}
if [[ $# -lt 2 ]]; then
   usage
   exit 1
fi

printf "\n===== Assigning JWT with second parameter =====\n"
PGD_FHIR_URL=$1
JWT=$2

printf "\nRetrieving Current QuestionnaireResponses\n"
printf "===========================================\n"
responseResults=$(curl -G --header "X-VAMF-JWT: $JWT" --insecure --header "Content-Type:application/json" "http://${PGD_FHIR_URL}/pgd-fhir-services/v1/fhir/QuestionnaireResponse" --data-urlencode "_count=100" --data-urlencode "_tag=f6879a68-49da-490b-a964-b6899ab4cd6b")
count=$(jq ".total" <<< $responseResults)
printf "\nResults found: $count\n"

# only delete if there are responseResults returned
if [[ $count -ne 0 ]]; then
  printf "\nDeleting Current QuestionnaireResponses\n"
  printf "===========================================\n"
  response_resources_urls=$(jq ".entry[].fullUrl" <<< $responseResults)
  printf "responseResults:\n$response_resources_urls"

  while read -r line; do
    # trim beginning and trailing quotes
    len=${#line}-1
    line="${line:1:len-1}"

    curl -X DELETE ${line} --header "X-VAMF-JWT: $JWT" --insecure --header "Content-Type:application/json"
  done <<< "$response_resources_urls"
fi

printf "\nRetrieving Current Questionnaires\n"
printf "===========================================\n"
results=$(curl -G --header "X-VAMF-JWT: $JWT" --insecure --header "Content-Type:application/json" "http://${PGD_FHIR_URL}/pgd-fhir-services/v1/fhir/Questionnaire" --data-urlencode "publisher=MyVAImages" --data-urlencode "_count=100")
count=$(jq ".total" <<< $results)
printf "\nResults found: $count\n"
printf "===========================================\n"

# only delete if there are results returned
if [[ $count -ne 0 ]]; then
  printf "\nDeleting Current Questionnaires\n"
  printf "===========================================\n"
  resources_urls=$(jq ".entry[].fullUrl" <<< $results)
  printf "results:\n$resources_urls"

  while read -r line; do
    # trim beginning and trailing quotes
    len=${#line}-1
    line="${line:1:len-1}"

    curl -X DELETE ${line} --header "X-VAMF-JWT: $JWT" --insecure --header "Content-Type:application/json"
  done <<< "$resources_urls"
fi

printf "\nSeeding Questionnaires Start\n"
printf "===========================================\n"

while read -r line || [[ -n $line ]];
do
    if [ ${line:0:1} == "[" ]; then
        line="${line:1}"
    fi
    len=${#line}-1
    line="${line:0:len}"

    curl --data "${line}" --header "X-VAMF-JWT: $JWT" --insecure --header "Content-Type:application/json" "http://${PGD_FHIR_URL}/pgd-fhir-services/v1/fhir/Questionnaire"
done <"questionnaireDataImport.json"

printf "\nSeeding Questionnaires End\n"
printf "===========================================\n"