#!/bin/bash
usage()
{
    echo "Usage:$0 <hostname:port>"
    echo "Ex: load-data.sh localhost PORT"
    echo ""
    echo "#######################################################################################"
    echo "Script requires the hostname or IP Address and port where mongo is running <mandatory>"
    echo "#######################################################################################"
}
if [[ $# -eq 0 ]]; then
   usage
   exit 1
fi

MONGO_USER=AI
MONGO_PASSWORD=AI
COLLECTION=mediaRequest
HOST="$1:$2"

echo "HOST is: $HOST"

printf "\n--------- Seeding Media Request Start ----------\n"
mongoimport -h $HOST -u $MONGO_USER -p $MONGO_PASSWORD -d $MONGO_USER -c $COLLECTION --file request-import-data.json --jsonArray --drop
printf "\n-----------------\nEnd\n"