define(['app', 'angular'], function (app, angular) {
	app.directive('listTable', function () {
		return {
			restrict: 'AE',
			scope: {
				'listItems' : '=',
				'headers' : '=',
				'onHeaderClick': '&',
				'rows' : '=',
				'onItemClick' : '&',
                'resultsMessage' : '=',
				'noResultsMessage' : '=',
				'noUnfilteredResultsTemplate' : '=',
				'unfilteredItemCount': '='
			},
			controller : function($scope, $parse){
				$scope.getDeepObjectValue = function(item, header) {
					var val = $parse(header.keys)(item);
					if(!angular.isUndefined(header.ifNull)) {
						return val || header.ifNull;
					}
					return val;
				};

				$scope.getDeepObjectValueHyphenateAndAppend = function(item, header) {
					var val = $parse(header.hyphenateAndAppendKeys)(item);
					if(!angular.isUndefined(header.ifNull)) {
						return val || header.ifNull;
					}
					return val;
				};

				$scope.isValueNull = function(item, header) {
					var value = $scope.getDeepObjectValue(item, header);
					return !(value || value === 0);
				};

				$scope.currPage = $scope.currPage || 1;
				$scope.numPages = $scope.numPages || 5;

				$scope.isPage = function (targetPage) {
					return $scope.currPage === targetPage;
				};
			},
			templateUrl: function(elem, attr) {
				return attr.useCellPartials ? 'modules/ui-components/table/table-with-cell-partials_template.html' : 'modules/ui-components/table/table_template.html';
			}
		};
	});
});