define(['angular', 'app', 'text!ui-components/scroll-indicator/scroll-indicator_template.html'], function (angular, app, template) {
    'use strict';

    app.directive('scrollIndicator', function ($compile) {
        return {
            restrict: 'A',
            link: function (scope, elem, attrs) {
                var parent = elem.parent();
                parent.prepend(template);

                scope.innerElem = elem.find('> div');
                scope.arrow = parent.find('> .arrow-indicator');
                scope.scrollProgress = parent.find('> .scroll-progress');
                scope.scrollProgressBar = parent.find('> .scroll-progress .scroll-progress-bar');
                scope.isIE11 = !!window.MSInputMethodContext && !!document.documentMode;

                $(elem).scroll(function () {
                    if (scope.showIndicators) {
                        scope.onScroll();
                    }
                });

                scope.$watch(function () {
                    return elem.outerHeight();
                }, function () {
                    scope.init();
                });

                scope.$watch(function () {
                    return scope.innerElem.outerHeight();
                }, function () {
                    scope.init();
                });

                scope.init = function () {
                    scope.showIndicators = elem.outerHeight() < scope.innerElem.outerHeight() && !elem.hasClass('inner-scroll');

                    scope.initStyles();
                };

                scope.initStyles = function () {
                    var offsetTop = elem.position().top,
                        height = elem.outerHeight();

                    if (scope.showIndicators) {
                        scope.arrow.css({
                            display: 'block',
                            opacity: 1,
                            top: (offsetTop + height - 50) + 'px'
                        });

                        scope.scrollProgress.css({
                            height: !scope.isIE11 ? (height - 1) + 'px' : 0,
                            top: offsetTop + 'px'
                        });

                        scope.scrollProgressBar.css('height', 0);
                    } else {
                        scope.arrow.css('display', 'none');
                        scope.scrollProgress.css('height', 0);
                    }
                };

                scope.onScroll = function () {
                    var position = elem.scrollTop(),
                        height = scope.innerElem.outerHeight() - elem.outerHeight(),
                        opacity = position / height,
                        percent = 100 * opacity,
                        display = percent >= 99 ? 'none' : 'block';

                    opacity = 1 - opacity;

                    scope.arrow.css({
                        'opacity': opacity,
                        'display': display
                    });

                    if (!scope.isIE11) {
                        scope.scrollProgressBar.css('height', percent + '%');
                    }
                };

                scope.$on('$destroy', function () {
                    parent.find('> .arrow-indicator, > .scroll-progress').remove();
                });
            }
        };
    });
});