define(['ProgressBar'], function () {
    'use strict';

    describe('Progress Bar Directive', function () {
        var scope,
            isolatedScope,
            compile,
            stateMock,
            timeoutCallback,
            element,
            progressServiceMock;

        beforeEach(function () {
            module('angularTemplateApp');

            progressServiceMock = jasmine.createSpyObj('progressService', ['getProgress']);
            stateMock = jasmine.createSpyObj('$state', ['go']);

            progressServiceMock.getProgress.and.returnValue(23);

            module(function ($provide) {
                $provide.value('progressService', progressServiceMock);
                $provide.value('$state', stateMock);
            });

            inject(function ($compile, $rootScope, $state, $templateCache) {
                var directive = angular.element('<progress-bar previous="previousCallback()" next="nextCallback()" />'),
                    template = '<div class="progress-bar-widget"> \
                        <button class="progress-bar-btn" ng-click="goPrevious()" ng-if="!hidePrevious"> \
                            <span aria-hidden="true" class="glyphicon glyphicon-arrow-left"></span> \
                            Previous \
                        </button> \
                        <div class="progress-wrapper" ng-class="{\'hide-previous\': hidePrevious}" aria-label="{{progress}}%" tabindex="0"> \
                            <span class="progress-status-text">{{progress}}%</span> \
                            <div class="progress-status-bar" ng-style="{width: progress + \'%\'}">{{progress}}%</div> \
                        </div> \
                        <button class="progress-bar-btn" ng-click="goNext()" ng-if="!hideNext"> \
                            <span aria-hidden="true" class="glyphicon glyphicon-arrow-right"></span> \
                            Next \
                        </button> \
                    </div>';

                compile = $compile;

                scope = $rootScope.$new();

                $templateCache.put('modules/ui-components/progress-bar/progress-bar_template.html', template);

                scope.previousCallback = function () {
                    $state.go('main.previous');
                };
                
                scope.nextCallback = function () {
                    $state.go('main.next');
                };

                element = $compile(directive)(scope);
                scope.$digest();

                isolatedScope = element.isolateScope();
            });
        });

        it('should get the progress from the progressService', function () {
            expect(isolatedScope.progress).toEqual(23);
        });

        it('should go to the previous page', function () {
            isolatedScope.goPrevious();

            expect(stateMock.go).toHaveBeenCalledWith('main.previous');
        });

        it('should go to the next page', function () {
            isolatedScope.goNext();

            expect(stateMock.go).toHaveBeenCalledWith('main.next');
        });

        describe('showing and hiding the navigation buttons', function () {
            it('should show the navigation buttons by default', function () {
                expect(element.find('button[ng-click="goPrevious()"]').length).toBeTruthy();
                expect(element.find('button[ng-click="goNext()"]').length).toBeTruthy();
            });

            it('should hide the navigation buttons when the hide attributes are set', function () {
                var directive = angular.element('<progress-bar hide-previous="true" hide-next="true" />');

                element = compile(directive)(scope);
                scope.$digest();

                expect(element.find('button[ng-click="goPrevious()"]').length).toBeFalsy();
                expect(element.find('.progress-wrapper.hide-previous').length).toBeTruthy();
                
                expect(element.find('button[ng-click="goNext()"]').length).toBeFalsy();
            });
        });
    });
});