define(['angular', 'app'], function (angular, app) {
    'use strict';

    app.directive('progressBar', function ($state, $timeout, progressService) {
        return {
            restrict: 'E',
            scope: {
                hidePrevious: '@',
                hideNext: '@',
                previous: '&',
                next: '&'
            },
            templateUrl: 'modules/ui-components/progress-bar/progress-bar_template.html',
            link: function (scope, elem, attrs) {
                scope.hidePrevious = attrs.hidePrevious;
                scope.hideNext = attrs.hideNext;
                scope.progress = progressService.getProgress();

                scope.goPrevious = function () {
                    if (typeof scope.previous === 'function') {
                        scope.previous();
                    }
                }

                scope.goNext = function () {
                    if (typeof scope.next === 'function') {
                        scope.next();
                    }
                }
                
                scope.$on('swipeLeft',function(event){
                    scope.goPrevious();
                });

                scope.$on('swipeRight',function(event){
                    scope.goNext();
                });
            }
        }
    });
});