define(['navBar'], function() {
	'use strict';

	describe("Nav-Bar directive", function (){
		var focusServiceMock,
            innerWidthMock = 1,
            scope,
			isolated,
			timeout,
            buttonMock = null,
			leftButtons = ["B1", "B2"],
			rightButtons = ["B3", "B4"];

		beforeEach(function () {
			module('angularTemplateApp');

            focusServiceMock = jasmine.createSpyObj('focusService', ['focusElement']);

			module(function($provide){
				$provide.value('focusService', focusServiceMock);
			});

			inject(function($compile, $rootScope, $templateCache, $timeout, $window, $state) {
			    var compiled,
                    element = angular.element("<nav-bar buttons='buttons' filter='filter'></nav-bar>");

                scope = $rootScope.$new();
                timeout = $timeout;
                $window.innerWidth = innerWidthMock;
                $state.current = {
                    name: "personal-trackers"
                };

				scope.buttons = buttonMock;
				scope.filter = true;

				$templateCache.put('modules/ui-components/nav-bar/nav-bar_template.html', '');

			    compiled = $compile(element)(scope);
			    scope.$digest();

			    isolated = compiled.isolateScope();
			});
		});

		describe("variables", function () {
			it ("should be correct (Scenario 1)", function() {
                expect(isolated.collapseThreshold).toBe(false);
                expect(isolated.status.toggleOpen).toBe(false);
                expect(isolated.isFilterCollapsed).toEqual(false);
                expect(isolated.buttons).toBe(null);
                expect(isolated.filter).toBe(true);

                buttonMock = {
                    left: [],
                    right: []
                };
			});

            it ("should be correct (Scenario 2)", function() {
                expect(isolated.collapseThreshold).toBe(false);
                expect(isolated.status.toggleOpen).toBe(false);
                expect(isolated.isFilterCollapsed).toEqual(false);
                expect(isolated.buttons).toEqual({
                    left: [],
                    right: []
                });
                expect(isolated.filter).toBe(true);

                buttonMock = {
                    left: leftButtons,
                    right: rightButtons
                };
            });

            it ("should be correct (Scenario 3)", function() {
                expect(isolated.collapseThreshold).toBe(true);
                expect(isolated.status.toggleOpen).toBe(false);
                expect(isolated.isFilterCollapsed).toEqual(false);
                expect(isolated.buttons).toEqual({
                    left: leftButtons,
                    right: rightButtons
                });
                expect(isolated.filter).toBe(true);

                buttonMock = {
                    left: [],
                    right: []
                };
            });
        });

		describe("functions", function () {
            it("should watch buttons", function() {
                expect(isolated.collapseThreshold).toBe(false);

                isolated.buttons = {
                    left: leftButtons,
                    right: rightButtons
                };

                scope.$apply();

                expect(isolated.collapseThreshold).toBe(true);

                isolated.buttons = {
                    left: leftButtons,
                    right: rightButtons
                };
            });

            it("should watch toggle", function() {
                isolated.status.toggleOpen = true;

                scope.$apply();

                isolated.status.toggleOpen = false;

                scope.$apply();
                timeout.flush(300);

                expect(focusServiceMock.focusElement).toHaveBeenCalledWith('button.dropdown-toggle')
            });

            it ("should determine if to collapse content (Scenario 1)", function() {
                isolated.collapseThreshold = false;

                expect(isolated.collapseButtons()).toBe(false);

                isolated.collapseThreshold = true;

                expect(isolated.collapseButtons()).toBe(true);

                innerWidthMock = 1000;
            });

            it ("should determine if to collapse content (Scenario 2)", function() {
                isolated.collapseThreshold = false;

                expect(isolated.collapseButtons()).toBe(false);

                isolated.collapseThreshold = true;

                expect(isolated.collapseButtons()).toBe(false);
            });

			it ("should toggle collapsed content", function() {
			    expect(isolated.showCollapseContent()).toBe(true);

                isolated.isFilterCollapsed = true;

                expect(isolated.showCollapseContent()).toBe(false);
			});

			it ("should toggle filter state", function() {
                expect(isolated.isFilterCollapsed).toBe(false);

			    isolated.toggleFilterState();

                expect(isolated.isFilterCollapsed).toBe(true);

                isolated.toggleFilterState();

                expect(isolated.isFilterCollapsed).toBe(false);
			});
		});
	});
});