define(['app', 'angular'], function (app) {
    app.directive('navBar', function (focusService, $timeout, $window, $state) {
        return {
            restrict: 'E',
            transclude : true,
            scope : {
                'buttons' : '=',
                'filter' : '=' //service, disable, defaults, model, callbacks (success, failure)
            },
            templateUrl: 'modules/ui-components/nav-bar/nav-bar_template.html',
            link: function(scope, elem, attrs) {
                scope.collapseThreshold = false;
                scope.status = {
                    toggleOpen: false
                };

                var setupButtonDropdown = function () {
                    var leftBtnsNum = scope.buttons.left ? scope.buttons.left.length : 0,
                        rightBtnsNum = scope.buttons.right ? scope.buttons.right.length : 0,
                        isPersonalTracker = $state.current.name.indexOf("personal-trackers") >= 0;
                    // Only collapse for Personal Trackers
                    if ((leftBtnsNum >= 2 || rightBtnsNum >= 2 || (leftBtnsNum + rightBtnsNum >= 2)) && isPersonalTracker) {
                        scope.collapseThreshold = true;
                    }

                    scope.$watch('status.toggleOpen', function (newVal, oldVal) {
                        if (newVal === false && oldVal === true) {
                            $timeout(function () {
                                focusService.focusElement('button.dropdown-toggle');
                            }, 300);
                        }
                    }, true);
                };

                if(scope.buttons) {
                    setupButtonDropdown();
                }

                var unbindButtonWatch = scope.$watch('buttons', function (newVal, oldVal) {
                    if (newVal && newVal !== oldVal) {
                        setupButtonDropdown();
                        unbindButtonWatch();
                    }
                }, true);

                scope.collapseButtons = function () {
                    return $window.innerWidth < 768 && scope.collapseThreshold;
                };

                scope.showCollapseContent = function(){
                    if (!scope.isFilterCollapsed) {
                        return true;
                    } else {
                        return false;
                    }
                };
            },
            controller: function ($scope) {
                $scope.isFilterCollapsed = false;
                $scope.toggleFilterState = function() {
                    $scope.isFilterCollapsed = !$scope.isFilterCollapsed;
                };
            }
        };
    });
});