define(['ViewVideoController'], function () {
    'use strict';

    describe("ViewVideoController", function () {
        var scope,
            $controller,
            httpMock,
            focusServiceMock,
            modalInstanceMock,
            callbackSpy,
            isVisible = false,
            wasVisible = false,
            videoUrl = 'http://test/1234/content',
            returnFocusElement = angular.element('fake'),
            mediaRequest = {
                requestReason: 'test'
            },
            evaluation = {
                images: [ { imageUrl: videoUrl } ]
            },
            videoResponse =  'video-blob';

        beforeEach(function () {
            module('angularTemplateApp');
            
            focusServiceMock = jasmine.createSpyObj('focusService', ['focusElement']);
            modalInstanceMock = jasmine.createSpyObj('$modalInstance', ['close']);
            callbackSpy = jasmine.createSpyObj('callbackSpy', ['triggerCallback']);

            callbackSpy.triggerCallback.and.callFake(function (callback) {
                callback(isVisible, wasVisible);
            });

            spyOn(window, '$').and.returnValue({
                is: function (attr) {
                    return isVisible;
                }
            });

            spyOn(URL, 'createObjectURL').and.callFake(function () {
                return 'someurl';
            });

            module(function ($provide) {
                $provide.value('focusService', focusServiceMock);
                $provide.value('$modalInstance', modalInstanceMock);
                $provide.value('mediaRequest', mediaRequest);
                $provide.value('evaluation', evaluation);
                $provide.value('returnFocusElement', returnFocusElement);
                
            });

            inject(function (_$rootScope_, _$controller_, $modal, $httpBackend) {
                $controller = _$controller_;
                scope = _$rootScope_.$new();
                httpMock = $httpBackend;

                spyOn(scope, '$watch').and.callFake(function (condition, callback) {
                    if (condition()) {
                        callbackSpy.triggerCallback(callback);
                    }
                });
            });
        });

        describe("Initial state", function () {
            beforeEach(function () {
                $controller('ViewVideoController', { $scope: scope });
            });

            it("should correctly set initial values", function () {
                expect(scope.videoUrl).toEqual(videoUrl);
            });
        });

        describe("Video load", function () {
            xit("should make a call to get the blob and createObjectURL with the blob", function () {
                isVisible = true;
                wasVisible = false;
                document.write("<video id='view-video'><source></video>");
                $controller('ViewVideoController', { $scope: scope });

                httpMock.expectGET(videoUrl).respond(200, videoResponse);
                httpMock.flush();
                scope.$digest();

                expect(window.$).toHaveBeenCalledWith('div.modal-header h3');
                expect(callbackSpy.triggerCallback).toHaveBeenCalled();
                expect(URL.createObjectURL).toHaveBeenCalledWith('video-blob');
            });
        });

        describe('modal close', function () {
            it ('should close modal instance', function () {
                $controller('ViewVideoController', {$scope: scope});
                scope.close();
                expect(modalInstanceMock.close).toHaveBeenCalled();
            });
        });
    });
});