define(['angular', 'app', 'global'], function (angular, app) {
	'use strict';

	app.controller('ViewVideoController', function ($scope, $http, $modalInstance, focusService, mediaRequest, evaluation, returnFocusElement, formatter) {
		$scope.mediaRequest = mediaRequest;
		$scope.videoUrl = evaluation.images[0].imageUrl;

		var loadVideoBlob = function () {
			var videoObj = angular.element('#view-video');
			if (videoObj) {
				$http({
					url: $scope.videoUrl,
                    method: 'GET',
				}).then(function (response) {
					videoObj[0].src = URL.createObjectURL(formatter.base64toBlob("data:"+response.data.content.contentType+";base64," + response.data.content.data));
					videoObj[0].fileName = response.data.content.title;
					videoObj[0].load();
				});
			}
		}

		$scope.$watch(function () {
			return $('div.modal-header h3').is(":visible");
		}, function (isVisible, wasVisible) {
			if (isVisible && !wasVisible) {
				loadVideoBlob();
				focusService.focusElement($('div.modal-header h3'));
			}
		});

		$scope.close = function () {
			$modalInstance.close();
			focusService.focusElement(returnFocusElement);
		};
	});
});