define(['ResourcesController'], function () {
    'use strict';

    describe("The Resource controller", function () {
		var controller,
			scope,
			modalInstanceMock,
			focusServiceMock,
			windowMock = window,
            isVisible = false,
            wasVisible = false,
            callbackSpy;

		beforeEach( function () {
			module('angularTemplateApp');

			modalInstanceMock = jasmine.createSpyObj('$modalInstance', ['close']);
			focusServiceMock = jasmine.createSpyObj('focusService', ['focusElement']);
            callbackSpy = jasmine.createSpyObj('callbackSpy', ['triggerCallback']);

            callbackSpy.triggerCallback.and.callFake(function (callback) {
                callback(isVisible, wasVisible);
            });

            spyOn(window, '$').and.returnValue({
                is: function () {
                    return isVisible;
                }
            });

			module(function($provide){
				$provide.value('$modalInstance', modalInstanceMock);
				$provide.value('focusService', focusServiceMock);
			});

			inject(function($controller, $rootScope) {
				scope = $rootScope.$new();
				controller = $controller;

                spyOn(scope, '$watch').and.callFake(function (condition, callback) {
                    if (condition()) {
                        callbackSpy.triggerCallback(callback);
                    }
				});
			});
		});

		describe('watch', function () {
            it('should not call the callback function if the header is not visible', function () {
                controller = controller('ResourcesController', {$scope: scope});
                scope.$apply();

                expect(window.$).toHaveBeenCalledWith('div.modal-header h3');
                expect(callbackSpy.triggerCallback).not.toHaveBeenCalled();
            });

            it('should call the callback function if the header is visible', function () {
                isVisible = true;

                controller = controller('ResourcesController', {$scope: scope});
                scope.$apply();

                expect(window.$).toHaveBeenCalledWith('div.modal-header h3');
                expect(callbackSpy.triggerCallback).toHaveBeenCalled();
            });

            it('should focus on the header if the header is now visible but wasn\'t visible previously', function () {
                isVisible = true;

                controller = controller('ResourcesController', {$scope: scope});
                scope.$apply();

                expect(focusServiceMock.focusElement).toHaveBeenCalledWith('div.modal-header h3');
            });

            it('should not focus on the header if the header is now visible and was visible previously', function () {
                isVisible = true;
                wasVisible = true;

                controller = controller('ResourcesController', {$scope: scope});
                scope.$apply();

                expect(focusServiceMock.focusElement).not.toHaveBeenCalled();
            });
        });

		describe('when the OK button is clicked', function (){
			beforeEach( function () {
				controller = controller('ResourcesController', {$scope:scope});
				scope.ok();
			});

			it ('should close the modal', function () {
				expect(modalInstanceMock.close).toHaveBeenCalled();
			});
        });

		describe('when the X button is clicked', function () {
			beforeEach( function () {
				controller = controller('ResourcesController', {$scope:scope});
				scope.ok();
			});

			it ('should close the modal', function () {
				expect(modalInstanceMock.close).toHaveBeenCalled();
			});
		});
	});
});