define(['angular', 'app', 'global'], function (angular, app) {
	'use strict';

	app.controller('PhotoTipsController', function ($scope, $stateParams, $modalInstance, focusService) {
		$scope.imageType = $stateParams.imageType;

		$scope.$watch(function () {
			return $('div.modal-header h3').is(":visible");
		}, function (isVisible, wasVisible) {
			if (isVisible && !wasVisible) {
                focusService.focusElement('div.modal-header h3');
			}
		});

		$scope.close = function () {
			$modalInstance.close();
			focusService.focusElement('button.info-btn');
		};
	});
});