define(['NavigationInstructionsController'], function() {
	'use strict';

	describe("Navigation Instructions Controller", function (){
		var controller,
			scope,
			focusServiceMock,
			localStorageServiceMock = {
				keys: []
			},
			fakeModal = {
				close: function() {}
			};

		beforeEach( function () {
			module('angularTemplateApp');

			focusServiceMock = jasmine.createSpyObj('focusService', ['focusElement']);

			module(function($provide){
				$provide.value('focusService', focusServiceMock);
				$provide.value('localStorageService', localStorageServiceMock);
			});


			inject(function($controller, $rootScope,$modal) {
				scope = $rootScope.$new();
				controller = $controller('NavigationInstructionsController', {$scope:scope, $modalInstance:fakeModal});

				spyOn($modal, 'open').and.returnValue(fakeModal);
				spyOn(fakeModal, 'close');
			});
		});

		describe("when the OK button is clicked", function (){
			it ("should close the modal", function() {
				scope.ok();
				expect(fakeModal.close).toHaveBeenCalled();
			});
		});

		describe("when the 'Don't Show Again' link is clicked", function (){

			it ("should close the modal", function() {
				scope.dontShowNavClicked();
				expect(fakeModal.close).toHaveBeenCalled();
			});

			it ("should expect the local storage to have been set to true", function() {
				localStorageServiceMock.keys['no-show-navigation-tips'] = 'no-show-navigation-tips'
				localStorage.setItem('no-show-navigation-tips', false);
				expect(localStorage.getItem('no-show-navigation-tips')).toEqual('false');

				scope.dontShowNavClicked();
				expect(localStorage.getItem('no-show-navigation-tips')).toEqual('true');
			});
		});

	});
});