define(['angular', 'app', 'global'], function (angular, app) {
	'use strict';

	app.controller('NavigationInstructionsController', function ($scope,$state, $timeout, $modalInstance, focusService,localStorageService ) {

		$scope.$watch(function () {
			return $('div.modal-header h3').is(":visible");
		}, function (isVisible, wasVisible) {
			if (isVisible && !wasVisible) {
				focusService.focusElement($('div.modal-header h3'));
			}
		});

		$scope.ok = function () {
			$timeout(function () {
				focusService.focusElement('.primary-header h2');
			}, 600);
			$modalInstance.close();
		};

		$scope.dontShowNavClicked = function () {
			localStorage.setItem(localStorageService.keys['no-show-navigation-tips'], true);
			$timeout(function () {
				focusService.focusElement('.primary-header h2');
			}, 600);
			$modalInstance.close();
		};
	});
});