define(['angular', 'app'], function (angular, app) {
	"use strict";
	app.service('modalService', function ($modal) {

		var modalDefaults = {
			backdrop: "static",
			keyboard: true,
			modalFade: true,
			templateUrl: 'modules/ui-components/modals/helper/modal_template.html',
			windowTemplateUrl: 'modules/ui-components/modals/helper/modal-window_template.html'
		};

		var modalContent = {
			closeButtonText: null,
			actionButtonText: null,
			headerText: null,
			bodyText: null,
			bodyContentUrl: null,
			data: null,
			type: null

		};

		this.showModal = function (customModalDefaults, customModalOptions, otherOptions) {
			if (!customModalDefaults) {
				customModalDefaults = {};
			}
			
			return this.show(customModalDefaults, customModalOptions, otherOptions);
		};

		this.show = function (customModalDefaults, customModalOptions, otherOptions) {
			var tempModalDefaults = {};
			var tempModalOptions = {};

			angular.extend(tempModalDefaults, modalDefaults, customModalDefaults);
			angular.extend(tempModalOptions, modalContent, customModalOptions);

			if (!tempModalDefaults.controller) {
				tempModalDefaults.controller = function ($scope, $modalInstance, focusService) {

					$scope.$watch(function () {
						return $('div.modal-header h3').is(":visible");
					}, function (isVisible, wasVisible) {
						if (isVisible && !wasVisible) {
                            focusService.focusElement($('div.modal-header h3'));
						}
					});

					// otherOptions currently only includes a layout flag for the modal buttons
					// current default is to have the 'cancel' button first, and then the 'okay' button
					if (otherOptions) {
						$scope.okButtonFirst = otherOptions.okButtonFirst;				
					}

					$scope.modalContent = tempModalOptions;
					$scope.modalContent.ok = function (result) {
						$modalInstance.close(result);
						if (typeof tempModalOptions.additionalAction === "function") {
							tempModalOptions.additionalAction();
						}
					};
                    $scope.modalContent.action = function (result) {
                        $modalInstance.dismiss('cancel');
                        if (typeof tempModalOptions.otherAction === "function") {
                            tempModalOptions.otherAction(result, $modalInstance);
                        }
                    };
					$scope.modalContent.close = function () {
						$modalInstance.dismiss('cancel');
					};
				}
			}

			return $modal.open(tempModalDefaults).result;
		};
	});
});