(function() {
    var android = navigator.userAgent.toLowerCase().indexOf('android') > -1;

    if (android) {
        var tableHeadings = [];

        document.querySelectorAll('table th').forEach(function (headingElement) {
            tableHeadings.push(headingElement.innerText);
        });

        document.querySelectorAll('table tr:not(.abb-heading)').forEach(function (rowElement) {
            var cells = rowElement.children;
            
            for (var i = 0; i < cells.length; i++) {
                var ariaLabel = document.createAttribute('aria-label');

                ariaLabel.value = tableHeadings[i] + ' ' + cells[i].innerText;

                cells[i].setAttributeNode(ariaLabel);
            }
        });
    }
})();