define(['ConsentDeclinedController'], function () {
    'use strict';

    describe('Consent Declined Controller', function () {
        var controller,
            scope,
            stateMock,
            modalInstanceMock,
            focusServiceMock,
            isVisible = false,
            wasVisible = false,
            callbackSpy;

        beforeEach(function () {
            module('angularTemplateApp');

            stateMock = jasmine.createSpyObj('$state', ['go']);
            modalInstanceMock = jasmine.createSpyObj('$modalInstance', ['close']);
            focusServiceMock = jasmine.createSpyObj('focusService', ['focusElement', 'focusMain']);
            callbackSpy = jasmine.createSpyObj('callbackSpy', ['triggerCallback']);

            callbackSpy.triggerCallback.and.callFake(function (callback) {
                callback(isVisible, wasVisible);
            });

            spyOn(window, '$').and.returnValue({
                is: function () {
                    return isVisible;
                }
            });

            module(function ($provide) {
                $provide.value('$state', stateMock);
                $provide.value('$modalInstance', modalInstanceMock);
                $provide.value('focusService', focusServiceMock);
            });

            inject(function ($controller, $rootScope) {
                scope = $rootScope.$new();
                controller = $controller;

                spyOn(scope, '$watch').and.callFake(function (condition, callback) {
                    if (condition()) {
                        callbackSpy.triggerCallback(callback);
                    }
                });
            });
        });

        describe('watch', function () {
            it('should not call the callback function if the header is not visible', function () {
                controller = controller('ConsentDeclinedController', {$scope: scope});
                scope.$apply();

                expect(window.$).toHaveBeenCalledWith('div.modal-header h3');
                expect(callbackSpy.triggerCallback).not.toHaveBeenCalled();
            });

            it('should call the callback function if the header is visible', function () {
                isVisible = true;

                controller = controller('ConsentDeclinedController', {$scope: scope});
                scope.$apply();

                expect(window.$).toHaveBeenCalledWith('div.modal-header h3');
                expect(callbackSpy.triggerCallback).toHaveBeenCalled();
            });

            it('should focus on the header if the header is now visible but wasn\'t visible previously', function () {
                isVisible = true;

                controller = controller('ConsentDeclinedController', {$scope: scope});
                scope.$apply();

                expect(focusServiceMock.focusElement).toHaveBeenCalledWith('div.modal-header h3');
            });

            it('should not focus on the header if the header is now visible and was visible previously', function () {
                isVisible = true;
                wasVisible = true;

                controller = controller('ConsentDeclinedController', {$scope: scope});
                scope.$apply();

                expect(focusServiceMock.focusElement).not.toHaveBeenCalled();
            });
        });

        describe("cancel function", function () {
            beforeEach(function () {
                controller = controller('ConsentDeclinedController', {$scope: scope});

                scope.cancel();
            });

            it("should close the current modal", function () {
                expect(modalInstanceMock.close).toHaveBeenCalled();
            });

            it("should focus on the I Do Not Consent button", function () {
                expect(focusServiceMock.focusElement).toHaveBeenCalledWith('button.do-not-consent');
            });
        });

        describe("ok function", function () {
            beforeEach(function () {
                controller = controller('ConsentDeclinedController', {$scope: scope});
                scope.ok();
            });

            it("should close the current modal", function () {
                expect(modalInstanceMock.close).toHaveBeenCalled();
                expect(focusServiceMock.focusMain).toHaveBeenCalled();
            });

            it("should redirect the user to the app select page", function () {
                expect(stateMock.go).toHaveBeenCalledWith('main.app-select');
            });
        });
    });
});