define(['angular', 'app', 'global'], function (angular, app) {
	'use strict';

	app.controller('ConsentDeclinedController', function ($scope, $state, $modalInstance, focusService) {
		$scope.$watch(function () {
			return $('div.modal-header h3').is(":visible");
		}, function (isVisible, wasVisible) {
			if (isVisible && !wasVisible) {
				focusService.focusElement('div.modal-header h3');
			}
		});

		$scope.cancel = function () {
			$modalInstance.close();
			focusService.focusElement('button.do-not-consent');
		};

		$scope.ok = function () {
			$modalInstance.close();
			$state.go('main.app-select');
			focusService.focusMain();
		};
	});
});