define(['angular', 'angularMocks', 'AboutController', 'angularUiBootstrap'], function(angular, mocks) {
    'use strict';

    describe("The About controller", function (){
        var controller, 
            scope,
            serviceMock,
			focusServiceMock,
            windowMock = window,
            fakeModal = {
                result: {
                    then: function() {}
                },
                close: function() {},
                dismiss: function() {}
            };

        beforeEach( function () {
            module('angularTemplateApp');

            serviceMock = jasmine.createSpyObj('pageService', ['getVersionNumber']);
			focusServiceMock = jasmine.createSpyObj('focusService', ['focusMain']);
            serviceMock.getVersionNumber.and.callFake(function(){
                return '1.0.0';
            });

            module(function($provide){
                $provide.value('pageService', serviceMock);
				$provide.value('focusService', focusServiceMock);
            });

            inject(function($controller, $rootScope) {
                scope = $rootScope.$new();
                controller = $controller('AboutController', {$scope:scope, $modalInstance:fakeModal});
            });

            inject(function($modal) {
                spyOn($modal, 'open').and.returnValue(fakeModal);
                spyOn(fakeModal, 'close');
            });
        });

        it ("should get the version number from the global service", function() {
            expect(serviceMock.getVersionNumber).toHaveBeenCalled();
            expect(scope.version).toEqual('1.0.0');
        });

        describe("when the OK button is clicked", function (){
            beforeEach( function () {
                scope.ok();
            });

            it ("should close the modal", function() {
                expect(fakeModal.close).toHaveBeenCalled();
            });
        });
    });
});