define(['angular', 'app', 'global'], function (angular, app) {
	'use strict';

	app.controller('ConfirmNavigationController', function ($scope, $modalInstance, focusService, params) {

		$scope.$watch(function () {
			return $('div.modal-header h3').is(":visible");
		}, function (isVisible, wasVisible) {
			if (isVisible && !wasVisible) {
                focusService.focusElement($('div.modal-header h3'));
			}
		});
		
		$scope.continue = function () {
			$modalInstance.close();
			focusService.focusElement('#'+params.id);
			$scope.openLink(params.href);
		};

		$scope.return = function() {
			$modalInstance.close();
			focusService.focusElement('#'+params.id);
		}
		
		$scope.openLink = function(href) {
			window.open(href);
		}

	});
});