define(['ConfirmMediaUpdateController'], function() {
    'use strict';

    describe("The Confirm Media Update controller", function (){
        var controller,
			scope,
            focusServiceMock,
			params,
			paramsProviderMock,
			modalInstanceMock;

        beforeEach( function () {
            module('angularTemplateApp');

            focusServiceMock = jasmine.createSpyObj('focusService', ['focusMain', 'focusElement']);
			modalInstanceMock = jasmine.createSpyObj('modalInstance', ['close']);
			paramsProviderMock = jasmine.createSpyObj('params', ['params']);



            module(function($provide){
                $provide.value('focusService', focusServiceMock);
				$provide.value('$modalInstance', modalInstanceMock);
				$provide.value('params', paramsProviderMock);

			});

            inject(function($controller, $rootScope, params) {
                scope = $rootScope.$new();
				controller = $controller('ConfirmMediaUpdateController', {
					$scope: scope,
					params: params
				});
			});

        });

        describe("when the Return button is clicked", function (){
            beforeEach( function () {
				scope.cancel();
            });

            it ("should close the modal", function() {
                expect(modalInstanceMock.close).toHaveBeenCalledWith({ "continue": false});
            });
        });

        describe("when the Continue button is clicked", function (){
            beforeEach( function () {
				scope.continue();
            });

            it ("should open a new browser window", function() {
                expect(modalInstanceMock.close).toHaveBeenCalledWith({ "continue": true});
            });
        });
    });
});