define(['ConfirmDialController'], function() {
    'use strict';

    describe("The Confirm Dial controller", function (){
        var controller,
			scope,
            focusServiceMock,
			params,
			paramsProviderMock,
			windowMock = window,
			modalInstanceMock;

        beforeEach( function () {
            module('angularTemplateApp');

            focusServiceMock = jasmine.createSpyObj('focusService', ['focusMain', 'focusElement']);
			modalInstanceMock = jasmine.createSpyObj('modalInstance', ['close']);
			paramsProviderMock = jasmine.createSpyObj('params', ['params']);



            module(function($provide){
                $provide.value('focusService', focusServiceMock);
				$provide.value('$modalInstance', modalInstanceMock);
				$provide.value('params', paramsProviderMock);

			});

            inject(function($controller, $rootScope, params) {
                scope = $rootScope.$new();
				controller = $controller;
				params = {id:'dial911', href: '911'};
				controller = $controller('ConfirmDialController', {
					$scope: scope,
					params: params
				});
			});

        });

        describe("when the Return button is clicked", function (){
            beforeEach( function () {
				scope.return();
            });

            it ("should close the modal", function() {
                expect(modalInstanceMock.close).toHaveBeenCalled();
            });
        });

        describe("when the Continue button is clicked", function (){
            beforeEach( function () {
                spyOn(windowMock, 'open');
				scope.continue();
            });

            it ("should open a new browser window", function() {
                expect(windowMock.open).toHaveBeenCalledWith('tel:911');
            });
        });
    });
});