define(['angular', 'app', 'global'], function (angular, app) {
	'use strict';

	app.controller('ConfirmDialController', function ($scope, $modalInstance, focusService, params) {

		$scope.number = params.href;

		$scope.$watch(function () {
			return $('div.modal-header h3').is(":visible");
		}, function (isVisible, wasVisible) {
			if (isVisible && !wasVisible) {
                focusService.focusElement($('div.modal-header h3'));
			}
		});
		
		$scope.continue = function () {
			$modalInstance.close();
			focusService.focusElement('#'+params.id);
			$scope.dialNumber();
		};

		$scope.return = function() {
			$modalInstance.close();
			focusService.focusElement('#'+params.id);
		}
		
		$scope.dialNumber = function() {
			window.open('tel:' + $scope.number);
		}

	});
});