define(['angular', 'angularMocks', 'AboutController', 'angularUiBootstrap'], function(angular, mocks) {
    'use strict';

    describe("The About controller", function (){
        var controller, 
            scope,
            modalInstanceMock,
            serviceMock,
			focusServiceMock,
            windowMock = window,
            isVisible = false,
            wasVisible = false,
            callbackSpy;

        beforeEach( function () {
            module('angularTemplateApp');

            modalInstanceMock = jasmine.createSpyObj('$modalInstance', ['close']);
            serviceMock = jasmine.createSpyObj('pageService', ['getVersionNumber']);
			focusServiceMock = jasmine.createSpyObj('focusService', ['focusElement']);
            callbackSpy = jasmine.createSpyObj('callbackSpy', ['triggerCallback']);

            serviceMock.getVersionNumber.and.callFake(function(){
                return '1.0';
            });

            callbackSpy.triggerCallback.and.callFake(function (callback) {
                callback(isVisible, wasVisible);
            });

            spyOn(window, '$').and.returnValue({
                is: function () {
                    return isVisible;
                }
            });

            module(function($provide){
                $provide.value('$modalInstance', modalInstanceMock);
                $provide.value('pageService', serviceMock);
				$provide.value('focusService', focusServiceMock);
            });

            inject(function($controller, $rootScope, $state) {
                scope = $rootScope.$new();
                controller = $controller;

                spyOn(scope, '$watch').and.callFake(function (condition, callback) {
                    if (condition()) {
                        callbackSpy.triggerCallback(callback);
                    }
                });

                spyOn($state, 'href').and.returnValue('eulaUrl');
            });
        });

        describe('watch', function () {
            it('should not call the callback function if the header is not visible', function () {
                controller = controller('AboutController', {$scope: scope});
                scope.$apply();

                expect(window.$).toHaveBeenCalledWith('div.modal-header h3');
                expect(callbackSpy.triggerCallback).not.toHaveBeenCalled();
            });

            it('should call the callback function if the header is visible', function () {
                isVisible = true;

                controller = controller('AboutController', {$scope: scope});
                scope.$apply();

                expect(window.$).toHaveBeenCalledWith('div.modal-header h3');
                expect(callbackSpy.triggerCallback).toHaveBeenCalled();
            });

            it('should focus on the header if the header is now visible but wasn\'t visible previously', function () {
                isVisible = true;

                controller = controller('AboutController', {$scope: scope});
                scope.$apply();

                expect(focusServiceMock.focusElement).toHaveBeenCalledWith('div.modal-header h3');
            });

            it('should not focus on the header if the header is now visible and was visible previously', function () {
                isVisible = true;
                wasVisible = true;

                controller = controller('AboutController', {$scope: scope});
                scope.$apply();

                expect(focusServiceMock.focusElement).not.toHaveBeenCalled();
            });
        });

        it ("should get the version number from the global service", function() {
            controller = controller('AboutController', {$scope: scope});
            expect(serviceMock.getVersionNumber).toHaveBeenCalled();
            expect(scope.version).toEqual('1.0');
        });

        describe("when the OK button is clicked", function (){
            beforeEach( function () {
                controller = controller('AboutController', {$scope: scope});
                scope.ok();
            });

            it ("should close the modal", function() {
                expect(modalInstanceMock.close).toHaveBeenCalled();
            });
        });

        describe("when EULA link is clicked", function (){
            beforeEach( function () {
                controller = controller('AboutController', {$scope: scope});
                spyOn(windowMock, 'open');
                scope.showEula();
            });

            it ("should open a new browser window", function() {
                expect(windowMock.open).toHaveBeenCalledWith('eulaUrl', '_blank', 'location=no,scrollbars=1,resizable=1');
            });
        });
    });
});