define(['angular', 'app', 'global'], function (angular, app) {
	'use strict';

	app.controller('AboutController', function ($scope, $state, $modalInstance, pageService, focusService) {

		$scope.$watch(function () {
			return $('div.modal-header h3').is(":visible");
		}, function (isVisible, wasVisible) {
			if (isVisible && !wasVisible) {
                focusService.focusElement('div.modal-header h3');
			}
		});
		$scope.version = pageService.getVersionNumber();

		$scope.ok = function () {
			$modalInstance.close();
		};

		$scope.showEula = function () {
			var url = $state.href('eula');
			window.open(url, "_blank", "location=no,scrollbars=1,resizable=1");
		};
	});
});