define(['limitLength'], function() {
	'use strict';

	describe("limitLength filter", function () {

		var limitLength;

        beforeEach(function () {
			module('angularTemplateApp');

			inject(function(limitLengthFilter) {
			    limitLength = limitLengthFilter;
			});
		});

		it('should not truncate shorter strings', function() {
			expect(limitLength('Hello world', 20)).toBe('Hello world');
		});

		it('should truncate on word boundaries', function() {
			expect(limitLength('Hello world', 10)).toBe('Hello&hellip;');
		});

		it('should truncate long words at the limit', function() {
			expect(limitLength('Supercalifragilisticexpialidocious', 10)).toBe('Supercalif&hellip;');
		});

		it('should preserve substrings', function() {
			expect(limitLength('Hello world', 10, 'world')).toBe('He&hellip;world');
		});

		it('should preserve substrings and prefixes where possible', function() {
			expect(limitLength('Hello dear world', 15, 'world')).toBe('Hello&hellip;world');
		});

		it('should preserve substrings with an end ellipsis where appropriate', function() {
			expect(limitLength('Hello my dear world', 16, 'dear')).toBe('Hello my dear&hellip;');
		});

		it('should preserve substrings with an end ellipsis where appropriate', function() {
			expect(limitLength('Hello my fabulous dear world', 15, 'dear')).toBe('Hello&hellip;dear&hellip;');
		});

		it('should preserve substrings as entire words', function() {
			expect(limitLength('Hello my fabulous dear world', 15, 'ear')).toBe('Hello&hellip;dear&hellip;');
		});
	});
});