define(['app', 'angular'], function (app) {

'use strict'

/**
 * A filter for friendly line truncation, truncating at the first word break before the length and appending an ellipsis.
 *
 * @param length The number of characters to allow before truncating.
 * @param preserve An optional text substring in the line to preserve, by having an internal ellipsis if needed.
 * @return string,
 */
app.filter('limitLength', function() {

  var ellipsis = '&hellip;';

  function truncateValue(value, length, preserve) {
    var preserveIndex = preserve ? value.toLowerCase().indexOf(preserve.toLowerCase()) : -1;
    var chopIndex = value.lastIndexOf(' ', length);
    if (chopIndex === -1)
      chopIndex = length;
    var endPreserveIndex = preserveIndex !== -1 ? value.indexOf(' ', preserveIndex + preserve.length) : -1;
    if (endPreserveIndex !== -1 && endPreserveIndex <= chopIndex)
      preserveIndex = -1;
    if (preserveIndex === -1)
      return value.substr(0, chopIndex) + ellipsis;
    else {
      preserveIndex = value.lastIndexOf(' ', preserveIndex) + 1;
      if (endPreserveIndex === -1)
        endPreserveIndex = value.length;
      var endEllipsis = (value.length - endPreserveIndex) > 3;
      var preserveLength = endPreserveIndex - preserveIndex + 3;
      if (endEllipsis)
        preserveLength += 3;
      if (preserveLength > length) {
        preserveLength = length;
        preserveIndex = (endPreserveIndex - length) + 3;
        if (endEllipsis)
          preserveIndex += 3;
      }
      chopIndex = value.lastIndexOf(' ', length - preserveLength);
      if (chopIndex === -1)
        chopIndex = length - preserveLength;
      var result = ellipsis;
      if (endEllipsis)
        result += value.substring(preserveIndex, endPreserveIndex) + ellipsis;
      else
        result += value.substring(preserveIndex);
      if (chopIndex > 0)
        result = value.substr(0, chopIndex) + result;
      return result;
    }
  }

  return function(value, length, preserve) {
    return value.length > length ? truncateValue(value, length, preserve) : value;
  };
});

});