define(['app', 'angular'], function (app, angular) {

	app.directive('userInputPattern', function () {
		return {
			restrict: 'A',
            require: 'ngModel',
			link:function(scope, elem, attrs, ngModelCtrl) {

                var prevModel = ngModelCtrl.$viewValue;
                var userPattern = scope.$eval(attrs.userInputPattern) ? new RegExp(scope.$eval(attrs.userInputPattern)) : /^.*$/;

				var onChange = function(newVal) {
					if(angular.isDefined(newVal) && newVal && !userPattern.test(newVal)) {
						ngModelCtrl.$setViewValue(prevModel);
						ngModelCtrl.$commitViewValue();
						ngModelCtrl.$render();
					} else {
						prevModel = newVal || '';
					}
					return prevModel;
				};

                ngModelCtrl.$parsers.push(onChange);
			}
		};
	});
});
