define(['app', 'angular'], function (app) {
	app.directive('requiredField', function ($compile) {
		return {
			restrict: 'A',
			scope: {
				isRequired: '='
			},
			link: function (scope, element, attrs) {
				var requiredTemplate = angular.element('<span class="required-field" ng-if="isRequired" responsive="true">* </span>'),
					template = $compile(requiredTemplate)(scope);

				element.prepend(template);
			}
		};
	});
});
