define(['app', 'angular'], function (app, angular) {
	app.directive('entryForm', function ($timeout, focusService, modalService, $modal, $rootScope) {
		return {
			restrict: 'AE',
			transclude: true,
			scope: {
				name: "@",
				service: "=",
				requireConfirmSave: "=",
				reviewTemplate: "=",
				callbacks: "=",
				ngModel: "=",
				actionsAllowed: "=",
				hideButtons: "=?",
				errorValidators: "=?",
				customDeleteSelector: "=?",
				hideRequiredMessage: "@"
			},
			link: function (scope, element) {
				var formCtrl = element.find("form:first").controller("form");

				if (scope.name) {
					formCtrl.$name = scope.name;
					scope.$parent[scope.name] = formCtrl;
				}

				function callback(type, response) {
					if (scope.callbacks) {
						if (scope.callbacks.common) {
							scope.callbacks.common(scope.ngModel, response);
						}
						if (scope.callbacks[type]) {
							scope.callbacks[type](scope.ngModel, response);
						}
					}
				}

				scope.isEditable = true;

				scope.$watch("ngModel", function (newVal, oldVal) {
					if (newVal !== oldVal) {
						formCtrl.validationSummary.clear();
					}
				});

				scope.requiredExists = function () {
					return element.find(":input[required]").length > 0;
				};

				scope.confirmSave = function (action) {
					//when: confirm save is not required
					//then: call save
					//else: confirm save
					if (!scope.requireConfirmSave) {
						scope.save(action);
					} else {
						//validate form before showing pop-up
						formCtrl.validationSummary.validate().then(function () {
							//consisent naming with the values of my-medication-entry template which is the first to utilize this
							var scopeWithModel = {
								reviewInputsTemplate: scope.reviewTemplate,
								details: scope.ngModel
							};

							//create new Angular scope
							var $modalScope = $rootScope.$new();

							//end Angular scope with my JSON object
							angular.extend($modalScope, scopeWithModel);

							var modalInstance = $modal.open({
								windowTemplateUrl: 'modules/ui-components/modals/helper/modal-window_template.html',
								templateUrl: 'modules/ui-components/modals/confirm-save/confirm-save_template.html',
								controller: 'ConfirmSaveController',
								scope: $modalScope
							});

							return modalInstance.result.then(function (result) {
								//when: the result is to save
								//then: save the form
								if (result.save) {
									scope.save();
									if (typeof action === "function") {
										action();
									}
								}
							});
						});
					}
				};

				scope.save = function (action) {
					formCtrl.validationSummary.validate().then(function () {
						if (scope.callbacks.allowSave) {
							scope.callbacks.allowSave().then(function () {
								if (typeof action === "function") {
									action();
								}
								makeRequest("save");
							});
						} else {
							makeRequest("save");
						}
					});
				};

				scope.delete = function () {
					var modalOptions = {
							closeButtonText: 'No',
							actionButtonText: 'Yes',
							headerText: 'Confirmation',
							bodyText: 'Are you sure you want to remove this entry? Select YES to remove the entry or NO to return to the entry screen.'
						},
					// Capture form dirty state
						formDirty = formCtrl.$dirty;

					modalService.showModal({}, modalOptions).then(function () {
						makeRequest("delete");
					}, function () {
						if (scope.customDeleteSelector) {
							focusService.focusElement(scope.customDeleteSelector);
						} else {
							focusService.focusElement(element.find('button[ng-click="delete()"]:last'));
						}
						// Force form dirty state. It gets wiped upon clicking the 'Delete' button
						formCtrl.$dirty = formDirty;
					});
				};

				scope.cancel = function () {
					formCtrl.$setPristine();
					callback("cancel");
				};

				function makeRequest(type) {
					scope.isEditable = false;
					var requestPromise = scope.service[type](scope.ngModel).then(function (response) {
						formCtrl.$setPristine();
						callback(type, response);
					}).finally(function () {
						scope.isEditable = true;
					});
					formCtrl.validationSummary.summarizeAsync(requestPromise);
				}

				formCtrl.entryFormActions = {
					confirmSave: scope.confirmSave,
					save: scope.save,
					delete: scope.delete,
					cancel: scope.cancel
				};
			},
			templateUrl: 'modules/ui-components/form/entry-form/entry-form_template.html'
		};
	});
});