define(['angular', 'app'], function (angular, app) {
    'use strict';

    app.directive('inputVideo', function ($timeout, globalDelayTracker) {
        return {
            restrict: 'EAC',
            scope: {
                btnText: '@',
                ngModel: '=',
                onSelect: '&'
            },
            link: function (scope, elem, attrs) {
                scope.isIE11 = !!window.MSInputMethodContext && !!document.documentMode;

                scope.captureVideo = function () {
                    elem.find('input[type="file"]')[0].click();
                };

                scope.onFileSelect = function () {
                    var files = elem.find('input[type="file"]')[0].files;
                    var file = files[0];

                    if (file) {
                        scope.ngModel.fileObj = file;

                        globalDelayTracker.add('read-file');

                        $timeout(function () {
                            scope.getVideoSrc(file, function (videoSrc) {
                                globalDelayTracker.remove('read-file');
                                
                                if (typeof scope.onSelect === 'function') {
                                    scope.onSelect();
                                }
                            });
                        });
                    }
                };

                scope.getVideoSrc = function (file, callback) {
                    var videoObj = angular.element('#' + attrs.videoObjectId);
        
                    if (videoObj[0].src.length > 0) {
                        URL.revokeObjectURL(videoObj[0].src);
                    }

                    if (scope.isIE11) {
                        var videoContainer = videoObj.parent();
                        videoObj.remove();

                        videoContainer.append("<video id='view-video' controls><source type='#'></video>");
                        videoContainer.find('video')[0].src = URL.createObjectURL(file);
                        videoContainer.find('video')[0].load();
                    }
                    else {
                        videoObj[0].src = URL.createObjectURL(file);
                        videoObj[0].load();
                    }

                    if (typeof callback === 'function') {
                        callback();
                    }
                };
            },
            templateUrl: 'modules/ui-components/form/controls/simple/input-video/input-video_template.html'
        }
    });
});