define(['InputTypeAhead'], function() {
	'use strict';

	describe("inputTypeAhead directive", function (){
        var isolated,
            compiled,
            allow = false,
            show = false,
            jqueryElem;

        beforeEach(function () {
            module('angularTemplateApp');

            jqueryElem = jasmine.createSpyObj('jqueryElem', ['find', 'index', 'scrollTop']);

            jqueryElem.find.and.returnValue(jqueryElem);
            jqueryElem.index.and.returnValue(4);
            
            spyOn(window, '$').and.returnValue(jqueryElem);

			inject(function($compile, $rootScope, $templateCache, $timeout) {
			    var scope = $rootScope.$new(),
			        element = angular.element("<input-type-ahead ng-model='model' prompt='Begin typing' label='Swing Dancer:' items='dancers' allow-new='allow' show-other='show'></input-type-ahead>");

				$templateCache.put('modules/ui-components/form/controls/simple/input-type-ahead/input-type-ahead_template.html', '');

                scope.allow = allow;
                scope.show = show;

			    compiled = $compile(element)(scope);
			    scope.$digest();
			    isolated = compiled.isolateScope();
			});
        });
        
        describe("keydown", function () {
            it ("should scroll based on the index of the active element when up is pressed", function () {
                var e = jQuery.Event("keydown");
                e.which = 38;

                compiled.trigger(e);

                expect(jqueryElem.scrollTop).toHaveBeenCalledWith(4 * 26);
            });

            it ("should scroll based on the index of the active element when down is pressed", function () {
                var e = jQuery.Event("keydown");
                e.which = 40;

                compiled.trigger(e);

                expect(jqueryElem.scrollTop).toHaveBeenCalledWith(4 * 26);
            });

            it ("should not scroll when another key besides up or down is pressed", function () {
                var e = jQuery.Event("keydown");
                e.which = 32;

                compiled.trigger(e);

                expect(jqueryElem.scrollTop).not.toHaveBeenCalled();
            });
        });

		describe("variables", function () {
			it ("should be defined", function() {
			    expect(isolated.errorHandling).toBeDefined();
                expect(isolated.errorHandling.required).toBeDefined();
                expect(isolated.errorHandling.required.message).toBe("Swing Dancer field is required.");
                expect(isolated.errorHandling.required.priority).toBe(1);
			});
        });

        describe("methods", function() {
            it ("should set the model to the passed value if a string", function() {
                isolated.setModel("scooter");

                expect(isolated.ngModel).toBe("scooter");
            });

            it ("should set the model to the passed value if an object", function() {
                isolated.useKey = "key";
                isolated.setModel({ "key": "seahorse"});

                expect(isolated.ngModel).toBe("seahorse");
            });

            it ("should not set the model and temp variable to 'Other' if not permitted", function() {
                isolated.setOther();

                expect(isolated.ngModel).not.toBe("Other");
                expect(isolated.myModel.tempVal).not.toBe("Other");
            });

            it ("should set the model and temp variable to 'Other' if permitted", function() {
                isolated.showOther = true;
                isolated.setOther();

                expect(isolated.ngModel).toBe("Other");
                expect(isolated.myModel.tempVal).toBe("Other");
            });

            it ("should not set the model to the passed value if not permitted", function() {
                isolated.setCustom("bumblebee");

                expect(isolated.ngModel).not.toBe("bumblebee");
            });

            it ("should set the model to the passed value if permitted", function() {
                isolated.allowNew = true;
                isolated.setCustom("bumblebee");

                expect(isolated.ngModel).toBe("bumblebee");
            });
        });

        describe("watcher", function() {
            it("should not delete ngModel if it equals the temp var", function() {
                isolated.ngModel = "crab cakes";
                isolated.myModel.tempVal = "crab cakes";
                isolated.$apply();

                expect(isolated.ngModel).toBe('crab cakes');

                allow = true;
            });

           it("should delete ngModel if it does not equal the temp var (1)", function() {
               isolated.ngModel = "sugar cookie";
               isolated.myModel.tempVal = "ping pong";
               isolated.$apply();

               expect(isolated.ngModel).toBeUndefined();

               allow = false;
               show = true;
           });

            it("should delete ngModel if it does not equal the temp var (2)", function() {
               isolated.ngModel = "sugar cookie";
               isolated.myModel.tempVal = "ping pong";
               isolated.$apply();

               expect(isolated.ngModel).toBeUndefined();

                show = false;
            });

            it("should delete ngModel if it does not equal the temp var (3)", function() {
               isolated.ngModel = "sugar cookie";
               isolated.myModel.tempVal = "ping pong";
               isolated.$apply();

               expect(isolated.ngModel).toBe('ping pong');
            });
        });
	});
});