define(['app', 'angular'], function (app) {

	app.directive('inputTypeAhead', function ($parse, $timeout) {
        return {
            restrict: 'E',
            require: 'ngModel',
            scope: {
                label: '@',
                name: '@',
                useKey: '@',
                prompt: '@',
                items: '=',
                ngModel: '=',
                ngRequired: '=',
                ngDisabled: '=',
                showOther: '=',
                allowNew: '=',
                maxlength: '=',
                useTextArea: '='
            },
            link: function(scope, elem, attrs, ngModelCtrl) {
                var label = scope.label && scope.label.replace(':', '').trim();
                scope.myModel = {
                    tempVal: scope.ngModel
                };
                scope.itemTemplateUrl = attrs.itemTemplateUrl;
                scope.typeaheadMinLength = attrs.typeaheadMinLength || 3;
                scope.onSelect = $parse(attrs.onSelect);
                scope.onType = $parse(attrs.onType);
                if (attrs.typeaheadTitle)
                    scope.typeaheadTitle = attrs.typeaheadTitle;
                else {
                    if (attrs.showOther || attrs.allowNew)
                        scope.typeaheadTitle = 'Type for a list of choices you can select from.';
                    else
                        scope.typeaheadTitle = 'Type a name or select one from the list provided.';
                }
                var minLength = Number(scope.typeaheadMinLength);
                if (!isNaN(minLength))
                    scope.typeaheadTitle += ' List suggestions are provided after ' + minLength + ' characters are typed.';
                scope.errorHandling = {
                    'required': {
                        message: label + ' field is required.',
                        priority: 1
                    }
                };

				scope.typeaheadFocused = false;
				elem.on('focusin', function() {
					$timeout(function () {
						if (elem[0].contains(document.activeElement)) {
							scope.typeaheadFocused = true;
						}
					});
				});

				elem.on('focusout', function() {
					$timeout(function () {
						if (!elem[0].contains(document.activeElement)) {
							scope.typeaheadFocused = false;
						}
					});
                });
                
                elem.on('keydown', function (e) {
                    var dropdown = $(elem.find('.dropdown-menu')[0]),
                        activeItemIndex = dropdown.find('li.active').index();

                    if (e.which === 38 || e.which === 40) {
                        dropdown.scrollTop(activeItemIndex * 26);
                    }
                });
            },
            controller: function ($rootScope, $scope) {
                $scope.getItems = function(val) {
                    if (typeof($scope.items) === 'function') {
                        return $scope.items(val).then(function (response) {
							return $scope.filteredItems = response;
						});
					}
                    return $scope.items;
                };

                $scope.setModel = function(item, model, label) {
                    if($scope.useKey) {
                        $scope.ngModel = item[$scope.useKey];
                    } else {
                        $scope.ngModel = item;
                    }
                    $scope.myModel.tempVal = $scope.ngModel;
                    $scope.onSelect($scope.$parent, {
                        $item: item,
                        $model: model,
                        $label: label
                    });
                };

                $scope.setOther = function() {
                    if ($scope.showOther) {
                        $scope.ngModel = "Other";
                        $scope.myModel.tempVal = "Other";
                    }
                };

                $scope.setCustom = function(newVal) {
                    if ($scope.allowNew) {
                        $scope.ngModel = newVal;
                    }
                };

                $rootScope.$on('clearTypeahead', function () {
                    $scope.myModel.tempVal = '';
                });

                $scope.$watch('myModel.tempVal', function(newVal) {
                    if ($scope.myModel.tempVal !== $scope.ngModel) {
                        if ($scope.allowNew || $scope.showOther) {
                            delete $scope.ngModel;
                        } else {
                            var old = $scope.ngModel;
                            $scope.ngModel = $scope.myModel.tempVal;
                            $scope.onType($scope.$parent, {
                                $new: $scope.myModel.tempVal,
                                $old: old
                            });
                        }
                    }
                });

                $scope.$watch('ngModel', function () {
					$scope.myModel.tempVal = $scope.ngModel;
				});
            },
			templateUrl: 'modules/ui-components/form/controls/simple/input-type-ahead/input-type-ahead_template.html'
		};
	});
});
