define(['InputText'], function() {
	'use strict';

	describe('Input Text Directive', function () {
		var scope,
			isolateScope,
			controller,
			elm,
			element,
			compile,
			label = 'testLabel',
			name = 'testName',
            capsBool = true,
			errorHandling = {
				'required' : {
					message: label + ' field is required.',
					priority: 1
				}
			};

		beforeEach(function () {
			module('angularTemplateApp');

			inject(function($templateCache) {
				$templateCache.put('modules/ui-components/form/controls/simple/input-text/input-text_template.html', 'stuff');
			});
		});

		describe('the directive', function () {
			beforeEach(function () {
				inject(function($rootScope, $compile, $timeout, $templateCache) {
					scope = $rootScope;
					compile = $compile;
					elm = "<input-text label='" + label + "' name='" + name + "' dont-capitalize='" + capsBool + "' ng-model='scope.someText' maxlength='20'></input-text>";
					element = $compile(elm)(scope);
					scope.$digest();

					isolateScope = element.isolateScope();
					isolateScope.ngModel = 'fakeModel';
				});
			});

			it('should have isolateScope variables defined', function () {
				expect(isolateScope.label).toEqual(label);
				expect(isolateScope.name).toEqual(name);
				expect(isolateScope.errorHandling).toEqual(errorHandling);
			});

			it('should have several controller functions defined', function () {
				expect(isolateScope.maxlength).toBeDefined();
				expect(isolateScope.charsLeft).toBeDefined();
			});

            it('should set noCaps off', function() {
                expect(isolateScope.noCap).toEqual("off");
                capsBool = false;
            });

            it('should set noCaps on', function() {
                expect(isolateScope.noCap).toEqual("on");
            });

			it('should calculate characters left for input field', function () {
				var ngModelController = element.controller('ngModel'),
					okayString = 'abcdef123456789',
					longString = 'abcdefghijkl123456789',
					clampedLongString = 'abcdefghijkl12345678';

				// calling update() manually since ng-change directive doesn't seem easily trigger-able in Jasmine
				ngModelController.$setViewValue(okayString);
				scope.$apply();
				expect(isolateScope.charsLeft).toEqual(5);

				ngModelController.$commitViewValue(longString);
				scope.$apply();

				expect(isolateScope.charsLeft).toEqual(5);

				expect(isolateScope.charsLeft).toEqual(5);

				// Current ng-model should be previously set string from before we went over character length limit
				expect(isolateScope.ngModel).toEqual(okayString);
			});
		});

		describe("required message attribute", function () {
			beforeEach(function () {
				inject(function($rootScope, $compile, $timeout, $templateCache) {
					scope = $rootScope;
					compile = $compile;
					elm = "<input-text label='" + label + "' name='" + name + "' dont-capitalize='" + capsBool + "' ng-model='scope.someText' maxlength='20' required-message='This field is required'></input-text>";
					element = $compile(elm)(scope);
					scope.$digest();

					isolateScope = element.isolateScope();
					isolateScope.ngModel = 'fakeModel';
				});
			});

			it('should allow a custom required message', function () {
				expect(isolateScope.errorHandling).toEqual({
					'required' : {
						message: 'This field is required',
						priority: 1
					}
				});
			});
		});
	});
});