define(['app', 'angular'], function (app, angular) {

	app.directive('inputText', function () {
		return {
			restrict: 'E',
			require: 'ngModel',
			scope: {
				'label': '@',
				'name': '@',
				'ngId': '@',
				'ngModel': '=',
				'ngDisabled': '=',
				'ngRequired': '=',
				'ngReadonly': '=',
				'characterCounter': '=',
				'maxlength': '@',
				'rows': '@',
				'cols': '@',
				'showSecondaryLabel': '=?',
				'secondaryLabel': '@?',
				'placeholder' : '@',
                'dontCapitalize' : "=",
				'useTextArea': '=',
				'requiredMessage': '@',
				'hideLabel': '='
			},
			link: function (scope) {
				var label = scope.label && scope.label.replace(/:/, '').trim();
				scope.errorHandling = {
					'required': {
						message: scope.requiredMessage || label + ' field is required.',
						priority: 1
					}
				};
			},
			controller: function ($scope) {
				var prevModel = $scope.ngModel;
				$scope.maxlength = $scope.maxlength || Infinity;
                $scope.noCap = $scope.dontCapitalize ? "off" : "on";

				$scope.$watch('ngModel', function () {
					if ($scope.ngModel && $scope.maxlength < getCharCountWithCarriageReturns()) {
						$scope.ngModel = prevModel;
					}
					prevModel = $scope.ngModel;

					$scope.charsLeft = $scope.maxlength - getCharCountWithCarriageReturns();
				});

				function getCharCountWithCarriageReturns() {
					return $scope.ngModel ? $scope.ngModel.replace(/\r(?!\n)|\n(?!\r)/g, "\r\n").length : 0;
				}
			},
			templateUrl: 'modules/ui-components/form/controls/simple/input-text/input-text_template.html'
		};
	});
});