define(['app', 'angular'], function (app) {

	app.directive('inputSelect', function () {
		return {
			restrict: 'E',
			require: 'ngModel',
			scope: {
				'label': '@',
				'hideLabel': '=',
				'name': '@',
				'ngId': '@',
				'nullLabel': '@',
				'hideNullOption': '=',
				'options': '=',
				'ngDisabled': '=',
				'ngRequired': '=',
				'ngModel': '=',
				'itemChangeCallback' : '&',
				'labelIcon': '=',
				'defaultValue': '@'
			},
			link: function (scope, element, attrs, ngModelCtrl) {
				scope.defaultValue = attrs.defaultValue || 'Select';
				var label = scope.label.lastIndexOf(":") === scope.label.length - 1 ? scope.label.substr(0, scope.label.length - 1) : scope.label;
				scope.errorHandling = {
					'required' : {
						message : label + ' field is required.',
						priority : 1
					}
				};

			},
			templateUrl: function (elem, attr) {
				return attr.useObjectOptions ? 'modules/ui-components/form/controls/simple/input-select/input-select-object_template.html' : 'modules/ui-components/form/controls/simple/input-select/input-select_template.html';
			}
		};
	});
});