define(['angular', 'app'], function (angular, app) {
    'use strict';

    app.directive('inputPhoto', function ($timeout, globalDelayTracker) {
        return {
            restrict: 'EAC',
            scope: {
                btnText: '@',
                ngModel: '=',
                onSelect: '&'
            },
            link: function (scope, elem, attrs) {
                scope.captureImage = function () {
                    elem.find('input[type="file"]')[0].click();
                };

                scope.onFileSelect = function () {
                    var files = elem.find('input[type="file"]')[0].files;
                    var file = files[0];

                    if (file) {
                        scope.ngModel.fileObj = file;

                        globalDelayTracker.add('read-file');

                        $timeout(function () {
                            scope.getImageSrc(file, function (imageSrc) {
                                globalDelayTracker.remove('read-file');
                                scope.ngModel.src = imageSrc;

                                if (typeof scope.onSelect === 'function') {
                                    scope.onSelect();
                                }
                            });
                        });
                    }
                };

                scope.getImageSrc = function (file, callback) {
                    var reader = new FileReader();
                    reader.onload = function (loadEvent) {
                        if (typeof callback === 'function') {
                            callback(loadEvent.target.result);
                        }
                    };

                    reader.readAsDataURL(file);
                };
            },
            templateUrl: 'modules/ui-components/form/controls/simple/input-photo/input-photo_template.html'
        }
    });
});