define(['app', 'angular'], function(app, angular) {

	app.directive('inputPhone', function($timeout) {
		return {
			restrict: 'E',
			require: 'ngModel',
			scope: {
				'label': '@',
				'name': '@',
				'ngModel': '=',
				'ngDisabled': '=',
				'ngRequired': '=',
				'ngReadonly': '=',
				'allowOconus': '='
			},
			link: function(scope, element, attrs, ngModelCtrl) {
				var label = scope.label && scope.label.replace(/:/, '').trim();
				scope.rawLabel = label;

				scope.errorHandling = {
					'required': {
						message: label + ' field is required.',
						priority: 1
					},
					'pattern': {
						message: label + ' must be formatted (###) ###-####.',
						priority: 2
					}
				};

				var phoneValidator = function(number) {
					var validationPattern = /^\(\d{3}\) \d{3}\-\d{4}$/,
						isRequired = (scope.ngModel || {}).useOconus || scope.ngRequired,
						validExistence = (isRequired && number) || !isRequired,
						validPattern;

					validPattern = !number || (validationPattern.test(number) && number);

					ngModelCtrl.$setValidity("required", validExistence);
					ngModelCtrl.$setValidity("pattern", validPattern);

					return validExistence && validPattern;
				};

				scope.oconusPattern = /^[0-9]{0,3}$/;

				scope.$watch('ngModel.value', function(newVal) {
					phoneValidator(newVal);
				}, true);

				scope.$watch('ngModel.useOconus', function(newVal, oldVal) {
					if (!newVal && oldVal) {
						scope.ngModel.countryCode = '';
					}
				}, true);
			},
			templateUrl: 'modules/ui-components/form/controls/simple/input-phone/input-phone_template.html'
		};
	});
});