define(['app', 'angular'], function (app, angular) {

	app.directive('inputNumber', function ($timeout) {
		return {
			restrict: 'E',
			require: 'ngModel',
			scope: {
				'label': '@',
				'labelIcon' : '=',
				'name': '@',
				'ngId': '@',
				'ngModel': '=',
				'ngReadonly': '=',
				'ngDisabled': '=',
				'ngRequired': '=',
                'validationPattern': '=?',
 				'min': '@',
 				'max': '@',
				'placeholder' : '@',
				'maxlength' : '@',
				'wholeNumbers': '@'
			},
			link:function(scope, elem, attrs, ngModelCtrl) {

				scope.wholeNumbers = attrs.wholeNumbers || false;
				var validationPattern = scope.validationPattern || !scope.wholeNumbers ? /^[0-9]*[.]?[0-9]*$/ : /^[0-9]*$/;

				var inputArea = elem.find('input');

								inputArea.bind('blur', function(){
									$timeout(function(){
										var preFloatifiedString = scope.ngModel;
										var floatifiedString;
										floatifiedString = preFloatifiedString && typeof parseFloat(preFloatifiedString) === "number" && isNaN(parseFloat(preFloatifiedString))=== false ? parseFloat(preFloatifiedString).toString() : '';
										scope.ngModel = floatifiedString +  (floatifiedString && preFloatifiedString.toString().lastIndexOf(".") === preFloatifiedString.length - 1 ? ".0" : "");
									});
								});

				scope.onChange = function () {
					if (scope.ngModel) {
						var pattern = !scope.wholeNumbers ? /[^0-9.]/g : /[^0-9]/g;
						scope.ngModel = scope.ngModel.replace(pattern, '');
					}
				};

                scope.min = scope.min ? scope.min : -Infinity;
                scope.max = scope.max ? scope.max : Infinity;

                ngModelCtrl.$name = scope.name;

                var validator = function(newVal) {
                	var newModelVal = parseFloat(newVal);
                	ngModelCtrl.$setValidity("range", ((!scope.ngRequired && (newVal === undefined || newVal === null || newVal === "")) || newModelVal <= scope.max && newModelVal >= scope.min));
                	ngModelCtrl.$setValidity("pattern", !newModelVal || validationPattern.test(newModelVal));
                	return newVal;
                };

                ngModelCtrl.$parsers.push(validator);
                ngModelCtrl.$formatters.push(validator);

                var label = scope.label.lastIndexOf(":") === scope.label.length - 1 ? scope.label.substr(0, scope.label.length - 1) : scope.label;

                scope.errorHandling = {
	                'required' : {
	                    message : label + ' field is required.',
	                    priority : 1
	                },
	                'range' : {
	                    message : label + " is outside the expected range. Please enter a value between " + scope.min + " and " + scope.max + ".",
	                    priority : scope.min && scope.max ? 2 : -1
	                }
                };

			},
			templateUrl: 'modules/ui-components/form/controls/simple/input-number/input-number_template.html'
		};
	});
});
