define(['jQuery', 'angular', 'angularUiBootstrap'], function ($, angular) {
	"use strict";

	var services = angular.module('accessibleTimePickerServices', ['ui.bootstrap'])
		.directive('focusMe', function ($timeout) {
            return {
                restrict: 'A',
                link: function (scope, element, attrs) {
                    scope.$watch(attrs.focusMe, function() {
                        if (scope.$eval(attrs.focusMe)) {
                            $timeout(function () {
                                element.focus();
                            }, 0);
                        }
                    });
                }
            };
        })
        .directive('accessibleTimePicker', function ($modal, $filter, $timeout) {
			return {
				restrict: 'A',
				require: 'ngModel',
				scope: {
					increment: '=?'
				},
				link: function (scope, element, attrs, ngModelCtrl) {
					element.bind('click', function (e) {
						e.preventDefault();
						var modalinstance = $modal.open({
							templateUrl: 'modules/ui-components/form/controls/simple/accessibletimepicker/accessibletimepicker_template.html',
							controller:  'accessibleTimePickerController',
							windowClass: 'date-picker-modal',
							resolve: {
								currentvalue: function () {
									return ngModelCtrl.$modelValue;
								},
								increment : function() {
									return scope.increment || 1;
								}
							}
						});
						modalinstance.result.then(function (value) {
							ngModelCtrl.$setViewValue((value.hour < 10 ? "0" : "") + value.hour + ":"
                                + (value.minute < 10 ? "0" : "") + value.minute + " "
                                + (value.period - 1 ? "PM": "AM"));
							ngModelCtrl.$render();
                      		$timeout(function(){
                            	element.focus();
                        	}, 600);
                       	}, function (dismissreason) {
                        	$timeout(function(){
                        	    element.focus();
                        	}, 600);
                        });
					});
				}
			};
		})
		.controller('accessibleTimePickerController', function ($scope, $modalInstance, currentvalue, increment) {
			var currentDate = new Date();

			var parseTime = function (inputTimeString) {
				var dateObj = new Date("12/12/1212 " + inputTimeString);
				var miliHours = dateObj.getHours();
				return {
					hour:   miliHours % 12,
					minute: dateObj.getMinutes(),
					period: miliHours >= 12 ? 2 : 1
				};
			};

            var parseTimeString = function(inputTimeString){
                return /^\d{1,2}:\d{1,2} [ap]m$/i.test(inputTimeString);
            };

			$scope.periods = ["AM", "PM"];
			var currentMinutes = currentDate.getMinutes();
			currentMinutes = increment*Math.floor(currentMinutes/increment);
			$scope.NOW = parseTime(currentDate.getHours() + ":" + currentMinutes);
			$scope.focusOn = 'hour';
			$scope.increment = increment;

			$scope.forNumber = function (num) {
				return new Array(num);
			};

			$scope.timeChosen = parseTimeString(currentvalue) ? parseTime(currentvalue) : $scope.NOW;
            $scope.$watch('timeChosen', function(){
                $scope.timeChosen.hour   = parseInt($scope.timeChosen.hour);
                $scope.timeChosen.minute = parseInt($scope.timeChosen.minute);
                $scope.timeChosen.period = parseInt($scope.timeChosen.period);

                $scope.timeChosen.hour = ($scope.timeChosen.hour > 12) ? 1 :
                    ($scope.timeChosen.hour < 1) ? 12 : $scope.timeChosen.hour;
                $scope.timeChosen.minute = ($scope.timeChosen.minute > 59) ? 0 :
                    ($scope.timeChosen.minute < 0) ? 59 : $scope.timeChosen.minute;
                $scope.timeChosen.period = ($scope.timeChosen.period > 2) ? 1 :
                    ($scope.timeChosen.period < 1) ? 2 : $scope.timeChosen.period;
            }, true);

			$scope.timeclick = function (typ, value) {
				$scope.timeChosen[typ] = value;
                $scope.focusOn = $scope.nextFocus[$scope.focusOn];
			};

			$scope.close = function (e) {
				$modalInstance.dismiss('cancel');
				e.preventDefault();
				return false;
			}
			$scope.set = function (e) {
				if (e) {
					e.preventDefault();
				}
				$modalInstance.close($scope.timeChosen);
				return false;
			};

			$scope.detectEscape = function (e) {
				if (e.which === 27) {
					$modalInstance.dismiss('cancel');
				}
			};

			$scope.formatHeading = function () {
				return "Selected time";
			};
            
            $scope.formatNum = function (num) {
                return num < 10 ? "0" + num : num;
            };

            $scope.nextFocus = {hour:'minute', minute:'period', period:'set', set:'close', close:'hour'};
            $scope.prevFocus = {hour:'close', close:'set', set:'period', period:'minute', minute:'hour'};
            
            $scope.previous = function (e) {
                var $target = $(e.currentTarget);
                var field = $target.attr('data-field');
                
                $scope.update(-1, field);
            };
            $scope.next = function (e) {
                var $target = $(e.currentTarget);
                var field = $target.attr('data-field');
                
                $scope.update(1, field);
            };
            $scope.update = function (dir, field) {
                $scope.timeChosen[field] += dir;
            };
		});
});
