define(['jQuery', 'angular', 'angularUiBootstrap'], function ($, angular) {
	"use strict";

	angular.module('accessibleDatePickerServices', ['ui.bootstrap'])
	.directive('focusMe', function ($timeout) {
		return {
			restrict: 'A',
			link: function (scope, element, attrs) {
				scope.$watch(attrs.focusMe, function() {
					if (scope.$eval(attrs.focusMe)) {
						$timeout(function () {
							element.focus();
						}, 0);
					}
				});
			}
		};
	})
	.directive('accessibleDatePicker', function ($modal, $filter, $timeout) {
		return {
			restrict: 'A',
			require: 'ngModel',
			scope: {
				allowedDateRange: "=",
				disableDaySelection: "=?",
				disableMonthSelection: "=?"
			},
			link: function (scope, element, attrs, ngModelCtrl) {
				element.bind('click', function (e) {
					e.preventDefault();
					var modalInstance = $modal.open({
						templateUrl: 'modules/ui-components/form/controls/simple/accessibledatepicker/accessibledatepicker_template.html',
						controller:  'accessibleDatePickerController',
						windowClass: scope.disableMonthSelection ? 'date-picker-modal-hidden-month' : (scope.disableDaySelection ? 'date-picker-modal-hidden-day' : 'date-picker-modal'),
						resolve: {
							currentvalue: function () {
								return ngModelCtrl.$modelValue;
							},
							allowedDateRange: function($q) {
								return $q.when(scope.allowedDateRange);
							},
							disableDaySelection: function($q) {
								return $q.when(scope.disableDaySelection);
							},
							disableMonthSelection: function($q) {
								return $q.when(scope.disableMonthSelection);
							}
						}
					});

					modalInstance.result.then(function (value) {
						var formattedDate = $filter('date')
						(new Date([value.month, value.day, value.year].join("/")), attrs.dateFormat);
						ngModelCtrl.$setViewValue(formattedDate);
						ngModelCtrl.$render();
						$timeout(function () {
							element.focus();
						}, 600);
					}, function () {
						$timeout(function () {
							element.focus();
						}, 600);
					});
				});
			}
		};
	})
	.controller('accessibleDatePickerController', function ($scope, $modalInstance, currentvalue, allowedDateRange, disableDaySelection, disableMonthSelection) {
		var currentDate = new Date();

		var parseDate = function (dateObj) {
			return {
				year:  dateObj.getFullYear(),
				month: dateObj.getMonth() + 1,
				day:   dateObj.getDate()
			}
		};

		$scope.disableDaySelection = disableDaySelection;
		$scope.disableMonthSelection = disableMonthSelection;
		$scope.getDate = function (dateObj) {
			return new Date(dateObj.year, dateObj.month - 1, dateObj.day);
		};

		if (typeof currentvalue === "string") {
			if (disableMonthSelection) {
				if (currentvalue.indexOf("01/01/") === -1) {
					currentvalue = "01/01/" + currentvalue;
				}
			} else if (disableDaySelection && currentvalue.length > 2 && currentvalue.indexOf("/01") !== 2) {
				currentvalue = currentvalue.slice(0, 2) + "/01" + currentvalue.slice(2, currentvalue.length);
			}
		}

		$scope.TODAY = parseDate(currentDate);
		$scope.DATE_MIN = allowedDateRange && allowedDateRange.min ? parseDate(new Date(allowedDateRange.min)) : parseDate(new Date("01/01/1900"));
		$scope.DATE_MAX = allowedDateRange && allowedDateRange.max ? parseDate(new Date(allowedDateRange.max)) : $scope.TODAY;

		$scope.WEEKDAYS = ["Su ", "Mo ", "Tu ", "We ", "Th ", "Fr ", "Sa "];
		$scope.MONTHS = ['JAN', 'FEB', 'MAR', 'APR', 'MAY', 'JUN', 'JUL', 'AUG', 'SEP', 'OCT', 'NOV', 'DEC'];
		$scope.focusOn = 'close';

		$scope.forNumber = function (num) {
			return new Array(num);
		};
		$scope.getYears = function (min, max) {
			var years = [],
				index;
			for (index = min; index <= max; index++) {
				years.push(index);
			}
			return years;
		};

		$scope.dateChosen = /^\d{2}\/\d{2}\/\d{4}$/.test(currentvalue) && (new Date(currentvalue)).toString() !== "Invalid Date"?
			parseDate(new Date(currentvalue)) : $scope.TODAY;

		$scope.$watch('dateChosen', function () {
			$scope.dateChosen.day   = parseInt($scope.dateChosen.day);
			$scope.dateChosen.month = parseInt($scope.dateChosen.month);
			$scope.dateChosen.year  = parseInt($scope.dateChosen.year);

			if ($scope.dateChosen.month > 12) {
				$scope.dateChosen.month = 12;
			}
			if ($scope.dateChosen.month <= 0) {
				$scope.dateChosen.month = 1;
			}
			if ($scope.dateChosen.year > $scope.DATE_MAX.year) {
				$scope.dateChosen.year = $scope.DATE_MAX.year;
			}
			if ($scope.dateChosen.year < $scope.DATE_MIN.year) {
				$scope.dateChosen.year = $scope.DATE_MIN.year;
			}
			if ($scope.dateChosen.day <= 0) {
				$scope.dateChosen.day = 1;
			}
			if ($scope.dateChosen.day > $scope.daysInMonth()) {
				$scope.dateChosen.day = $scope.daysInMonth();
			}
			var d = new Date($scope.dateChosen.year, $scope.dateChosen.month - 1, $scope.dateChosen.day);
			if (d > $scope.getDate($scope.DATE_MAX)) {
				$.extend($scope.dateChosen, $scope.DATE_MAX);
			}
			if (d < $scope.getDate($scope.DATE_MIN)) {
				$.extend($scope.dateChosen, $scope.DATE_MIN);
			}
		}, true);

		$scope.daysInMonth = function () {
			return $scope.dateChosen.year === undefined || $scope.dateChosen.month === undefined ? 31 :
				new Date($scope.dateChosen.year, $scope.dateChosen.month, 0).getDate();
		};

		$scope.isMinYear = function () {
			return $scope.DATE_MIN.year === $scope.dateChosen.year;
		};

		$scope.isMaxYear = function () {
			return $scope.DATE_MAX.year === $scope.dateChosen.year;
		};

		$scope.underMinMonth = function (month) {
			return $scope.isMinYear() && $scope.DATE_MIN.month > month;
		};

		$scope.aboveMaxMonth = function (month) {
			return $scope.isMaxYear() && $scope.DATE_MAX.month < month;
		};

		$scope.underMinDate = function (day) {
			return $scope.isMinYear() && $scope.DATE_MIN.month === $scope.dateChosen.month && $scope.DATE_MIN.day > day;
		};

		$scope.aboveMaxDate = function (day) {
			return $scope.isMaxYear() && $scope.DATE_MAX.month === $scope.dateChosen.month && $scope.DATE_MAX.day < day;
		};

		$scope.close = function (e) {
			$modalInstance.dismiss('cancel');
            if (e && typeof e.preventDefault === "function") {
			    e.preventDefault();
            }
			return false;
		};
		$scope.set = function (e) {
			if (e) {
				e.preventDefault();
			}
			$modalInstance.close($scope.dateChosen);
			return false;
		};
        $scope.previous = function (e) {
            var field = $(e.currentTarget).attr('data-field');
            
            $scope.update(-1, field);
        };
        $scope.next = function (e) {
            var field = $(e.currentTarget).attr('data-field');
            
            $scope.update(1, field);
        };
        $scope.update = function (dir, field) {
            $scope.dateChosen[field] += dir;
        };

		$scope.detectEscape = function (e) {
			if (e.which === 27) {
				$modalInstance.dismiss('cancel');
			}
		};

		$scope.formatHeading = function () {
			var calcDate = new Date($scope.dateChosen.year, $scope.dateChosen.month - 1, $scope.dateChosen.day);
			return calcDate.toDateString() === currentDate.toDateString() ?
				"Today" : calcDate.toDateString();
		};
	});
});
